/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.data.v2.core;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.api.data.v2.core.ForgeDataProviderContext;
import fuzs.puzzleslib.neoforge.impl.data.ExistingFileHelperHolder;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public final class DataProviderHelper {
    private DataProviderHelper() {
    }

    public static void registerDataProviders(String modId, ForgeDataProviderContext.Factory ... factories) {
        if (!ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        Preconditions.checkState((factories.length > 0 ? 1 : 0) != 0, (Object)"data provider factories is empty");
        DataProviderHelper.registerDataProviders(modId, (ForgeDataProviderContext.LegacyFactory[])Stream.of(factories).map(factory -> (evt, $) -> (DataProvider)factory.apply(ForgeDataProviderContext.fromEvent(modId, evt))).toArray(ForgeDataProviderContext.LegacyFactory[]::new));
    }

    public static void registerDataProviders(String modId, ForgeDataProviderContext.LegacyFactory ... factories) {
        if (!ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        Preconditions.checkState((factories.length > 0 ? 1 : 0) != 0, (Object)"data provider factories is empty");
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> eventBus.addListener(evt -> DataProviderHelper.onGatherData(evt, modId, factories)));
    }

    static void onGatherData(GatherDataEvent evt, String modId, ForgeDataProviderContext.LegacyFactory ... factories) {
        Preconditions.checkState((factories.length > 0 ? 1 : 0) != 0, (Object)"data provider factories is empty");
        DataGenerator dataGenerator = evt.getGenerator();
        for (ForgeDataProviderContext.LegacyFactory factory : factories) {
            DataProvider dataProvider = (DataProvider)factory.apply(evt, modId);
            if (dataProvider instanceof ExistingFileHelperHolder) {
                ExistingFileHelperHolder holder = (ExistingFileHelperHolder)dataProvider;
                holder.puzzleslib$setExistingFileHelper(evt.getExistingFileHelper());
            }
            dataGenerator.addProvider(true, dataProvider);
        }
    }
}

