/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.core.context;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.init.v1.BuiltinItemRenderer;
import fuzs.puzzleslib.api.client.init.v1.ReloadingBuiltInItemRenderer;
import fuzs.puzzleslib.api.core.v1.resources.ForwardingReloadListenerHelper;
import fuzs.puzzleslib.neoforge.impl.client.core.NeoForgeClientItemExtensionsImpl;
import fuzs.puzzleslib.neoforge.mixin.client.accessor.ItemNeoForgeAccessor;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public record BuiltinModelItemRendererContextNeoForgeImpl(String modId, List<ResourceManagerReloadListener> dynamicRenderers) implements BuiltinModelItemRendererContext
{
    @Override
    public void registerItemRenderer(final BuiltinItemRenderer renderer, ItemLike ... items) {
        if (FMLLoader.getLaunchHandler().isData()) {
            return;
        }
        Objects.requireNonNull(renderer, "renderer is null");
        Objects.requireNonNull(items, "items is null");
        Preconditions.checkState((items.length > 0 ? 1 : 0) != 0, (Object)"items is empty");
        IClientItemExtensions itemExtensions = new IClientItemExtensions(){
            @Nullable
            private BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.blockEntityWithoutLevelRenderer == null) {
                    this.blockEntityWithoutLevelRenderer = new ForwardingBlockEntityWithoutLevelRenderer(Minecraft.getInstance(), renderer);
                }
                return this.blockEntityWithoutLevelRenderer;
            }
        };
        for (ItemLike item : items) {
            Objects.requireNonNull(item, "item is null");
            BuiltinModelItemRendererContextNeoForgeImpl.setClientItemExtensions(item.asItem(), itemExtensions);
        }
    }

    @Override
    public void registerItemRenderer(ReloadingBuiltInItemRenderer renderer, ItemLike ... items) {
        this.registerItemRenderer((BuiltinItemRenderer)renderer, items);
        String itemName = BuiltInRegistries.ITEM.getKey((Object)items[0].asItem()).getPath();
        ResourceLocation identifier = new ResourceLocation(this.modId, itemName + "_built_in_model_renderer");
        this.dynamicRenderers.add((ResourceManagerReloadListener)ForwardingReloadListenerHelper.fromResourceManagerReloadListener(identifier, renderer));
    }

    private static void setClientItemExtensions(Item item, final IClientItemExtensions itemExtensions) {
        Object renderProperties = ((ItemNeoForgeAccessor)item).puzzleslib$getRenderProperties();
        ((ItemNeoForgeAccessor)item).puzzleslib$setRenderProperties(renderProperties != null ? new NeoForgeClientItemExtensionsImpl((IClientItemExtensions)renderProperties){

            @Override
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return itemExtensions.getCustomRenderer();
            }
        } : itemExtensions);
    }

    private static class ForwardingBlockEntityWithoutLevelRenderer
    extends BlockEntityWithoutLevelRenderer {
        private final BuiltinItemRenderer renderer;

        public ForwardingBlockEntityWithoutLevelRenderer(Minecraft minecraft, BuiltinItemRenderer renderer) {
            super(minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels());
            this.renderer = renderer;
        }

        public void renderByItem(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
            this.renderer.renderByItem(stack, mode, matrices, vertexConsumers, light, overlay);
        }
    }
}

