/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.network;

import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistryImpl;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.impl.core.NeoForgeProxy;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.jetbrains.annotations.Nullable;

public class NetworkHandlerNeoForgeV3
extends NetworkHandlerRegistryImpl {
    @Nullable
    private IPayloadRegistrar channel;

    public NetworkHandlerNeoForgeV3(ResourceLocation channelName) {
        super(channelName);
    }

    @Override
    public <T extends Record> void registerClientbound$Internal(Class<?> clazz) {
        this.register(clazz, (arg_0, arg_1) -> NetworkHandlerNeoForgeV3.lambda$registerClientbound$Internal$0((NeoForgeProxy)Proxy.INSTANCE, arg_0, arg_1), IDirectionAwarePayloadHandlerBuilder::client, IDirectionAwarePayloadHandlerBuilder::server);
    }

    @Override
    public <T extends Record> void registerServerbound$Internal(Class<?> clazz) {
        this.register(clazz, (arg_0, arg_1) -> NetworkHandlerNeoForgeV3.lambda$registerServerbound$Internal$1((NeoForgeProxy)Proxy.INSTANCE, arg_0, arg_1), IDirectionAwarePayloadHandlerBuilder::server, IDirectionAwarePayloadHandlerBuilder::client);
    }

    private <T> void register(Class<T> clazz, BiFunction<T, PlayPayloadContext, CompletableFuture<Void>> handle, GenericPayloadHandler<T> receiverHandler, GenericPayloadHandler<T> senderHandler) {
        Objects.requireNonNull(this.channel, "channel is null");
        Function<FriendlyByteBuf, Object> factory = MessageSerializers.findByType(clazz)::read;
        ResourceLocation messageName = this.registerMessageType(clazz);
        this.channel.play(messageName, friendlyByteBuf -> new CustomPacketPayloadAdapter(factory.apply((FriendlyByteBuf)friendlyByteBuf), messageName), builder -> {
            receiverHandler.accept(builder, (payload, context) -> ((CompletableFuture)handle.apply(payload.message(), context)).exceptionally(throwable -> {
                String modName = ModLoaderEnvironment.INSTANCE.getModContainer(this.channelName.getNamespace()).map(ModContainer::getDisplayName).orElse(this.channelName.getNamespace());
                context.packetHandler().disconnect((Component)Component.literal((String)"Receiving %s from %s failed: %s".formatted(clazz.getSimpleName(), modName, throwable.getMessage())));
                return null;
            }));
            senderHandler.accept(builder, (payload, context) -> {
                String modName = ModLoaderEnvironment.INSTANCE.getModContainer(this.channelName.getNamespace()).map(ModContainer::getDisplayName).orElse(this.channelName.getNamespace());
                context.packetHandler().disconnect((Component)Component.literal((String)"Receiving %s from %s on wrong side!".formatted(clazz.getSimpleName(), modName)));
            });
        });
    }

    @Override
    public <T extends Record> Packet<ClientCommonPacketListener> toClientboundPacket(T message) {
        Objects.requireNonNull(message, "message is null");
        return this.toPacket(ClientboundCustomPayloadPacket::new, message);
    }

    @Override
    public <T extends Record> Packet<ServerCommonPacketListener> toServerboundPacket(T message) {
        Objects.requireNonNull(message, "message is null");
        return this.toPacket(ServerboundCustomPayloadPacket::new, message);
    }

    private <T extends Record, S extends PacketListener> Packet<S> toPacket(Function<CustomPacketPayload, Packet<S>> packetFactory, T message) {
        return this.toPacket(message, (resourceLocation, consumer) -> (Packet)packetFactory.apply(new CustomPacketPayloadAdapter<Record>(message, (ResourceLocation)resourceLocation, (Consumer<FriendlyByteBuf>)consumer)));
    }

    @Override
    public void build() {
        NeoForgeModContainerHelper.getOptionalModEventBus(this.channelName.getNamespace()).ifPresent(eventBus -> eventBus.addListener(evt -> {
            if (this.channel != null) {
                throw new IllegalStateException("channel is already built");
            }
            this.channel = evt.registrar(this.channelName.toLanguageKey());
            if (this.optional) {
                this.channel = this.channel.optional();
            }
            super.build();
            this.channel = null;
        }));
    }

    private static /* synthetic */ CompletableFuture lambda$registerServerbound$Internal$1(NeoForgeProxy rec$, Object x$0, PlayPayloadContext x$1) {
        return rec$.registerServerReceiverV2((Record)x$0, x$1);
    }

    private static /* synthetic */ CompletableFuture lambda$registerClientbound$Internal$0(NeoForgeProxy rec$, Object x$0, PlayPayloadContext x$1) {
        return rec$.registerClientReceiverV2((Record)x$0, x$1);
    }

    static interface GenericPayloadHandler<T>
    extends BiConsumer<IDirectionAwarePayloadHandlerBuilder<CustomPacketPayloadAdapter<T>, IPlayPayloadHandler<CustomPacketPayloadAdapter<T>>>, IPlayPayloadHandler<CustomPacketPayloadAdapter<T>>> {
    }

    record CustomPacketPayloadAdapter<T>(T message, ResourceLocation messageName, Consumer<FriendlyByteBuf> writer) implements CustomPacketPayload
    {
        CustomPacketPayloadAdapter(T message, ResourceLocation messageName) {
            this(message, messageName, friendlyByteBuf -> {
                throw new UnsupportedOperationException();
            });
        }

        public void write(FriendlyByteBuf buffer) {
            this.writer.accept(buffer);
        }

        public ResourceLocation id() {
            return this.messageName;
        }
    }
}

