/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.attachment.v4;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.attachment.v4.DataAttachmentType;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.impl.attachment.DataAttachmentRegistryImpl;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class DataAttachmentRegistry {
    private DataAttachmentRegistry() {
    }

    public static <V> EntityBuilder<V> entityBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getEntityTypeBuilder();
    }

    public static <V> BlockEntityBuilder<V> blockEntityBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getBlockEntityTypeBuilder();
    }

    public static <V> Builder<LevelChunk, V> levelChunkBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getLevelChunkBuilder();
    }

    public static <V> Builder<Level, V> levelBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getLevelBuilder();
    }

    public static interface EntityBuilder<V>
    extends RegistryBuilder<Entity, V> {
        public EntityBuilder<V> persistent(Codec<V> var1);

        default public EntityBuilder<V> defaultValue(V defaultValue) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue(defaultValue);
        }

        default public EntityBuilder<V> defaultValue(Function<RegistryAccess, V> defaultValueProvider) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue((Function)defaultValueProvider);
        }

        default public EntityBuilder<V> defaultValue(Class<? extends Entity> holderType, V defaultValue) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue(holderType, defaultValue);
        }

        default public EntityBuilder<V> defaultValue(EntityType<?> entityType, V defaultValue) {
            return this.defaultValue(entity -> entity.getType() == entityType, (Object)defaultValue);
        }

        default public EntityBuilder<V> defaultValue(Predicate<Entity> defaultFilter, V defaultValue) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue(defaultFilter, defaultValue);
        }

        public EntityBuilder<V> defaultValue(Predicate<Entity> var1, Function<RegistryAccess, V> var2);

        default public EntityBuilder<V> networkSynchronized(StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec) {
            return this.networkSynchronized(streamCodec, null);
        }

        public EntityBuilder<V> networkSynchronized(StreamCodec<? super RegistryFriendlyByteBuf, V> var1, @Nullable Function<Entity, PlayerSet> var2);

        public EntityBuilder<V> copyOnDeath();
    }

    public static interface BlockEntityBuilder<V>
    extends RegistryBuilder<BlockEntity, V> {
        default public BlockEntityBuilder<V> defaultValue(V defaultValue) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue(defaultValue);
        }

        default public BlockEntityBuilder<V> defaultValue(Function<RegistryAccess, V> defaultValueProvider) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue((Function)defaultValueProvider);
        }

        default public BlockEntityBuilder<V> defaultValue(Class<? extends BlockEntity> holderType, V defaultValue) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue(holderType, defaultValue);
        }

        default public BlockEntityBuilder<V> defaultValue(BlockEntityType<?> blockEntityType, V defaultValue) {
            return this.defaultValue(blockEntity -> blockEntity.getType() == blockEntityType, (Object)defaultValue);
        }

        default public BlockEntityBuilder<V> defaultValue(Predicate<BlockEntity> defaultFilter, V defaultValue) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue(defaultFilter, defaultValue);
        }

        public BlockEntityBuilder<V> defaultValue(Predicate<BlockEntity> var1, Function<RegistryAccess, V> var2);

        public BlockEntityBuilder<V> persistent(Codec<V> var1);
    }

    public static interface Builder<T, V> {
        default public Builder<T, V> defaultValue(V defaultValue) {
            return this.defaultValue(registries -> defaultValue);
        }

        public Builder<T, V> defaultValue(Function<RegistryAccess, V> var1);

        public Builder<T, V> persistent(Codec<V> var1);

        public DataAttachmentType<T, V> build(ResourceLocation var1);
    }

    public static interface RegistryBuilder<T, V>
    extends Builder<T, V> {
        @Override
        default public RegistryBuilder<T, V> defaultValue(Function<RegistryAccess, V> defaultValueProvider) {
            return this.defaultValue((Predicate<T>)Predicates.alwaysTrue(), defaultValueProvider);
        }

        default public RegistryBuilder<T, V> defaultValue(Class<? extends T> holderType, V defaultValue) {
            return this.defaultValue(holderType::isInstance, defaultValue);
        }

        default public RegistryBuilder<T, V> defaultValue(Predicate<T> defaultFilter, V defaultValue) {
            return this.defaultValue(defaultFilter, registries -> defaultValue);
        }

        public RegistryBuilder<T, V> defaultValue(Predicate<T> var1, Function<RegistryAccess, V> var2);
    }
}

