/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v3.data;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.CopyStrategy;
import fuzs.puzzleslib.api.capability.v3.data.SyncStrategy;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.impl.capability.ClientboundEntityCapabilityMessage;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface EntityCapabilityKey<T extends Entity, C extends CapabilityComponent<T>>
extends CapabilityKey<T, C> {
    public SyncStrategy getSyncStrategy();

    public CopyStrategy getCopyStrategy();

    @Override
    default public void setChanged(C capabilityComponent, @Nullable PlayerSet playerSet) {
        if (((Entity)((CapabilityComponent)capabilityComponent).getHolder()).level().isClientSide) {
            playerSet = PlayerSet.ofNone();
        } else if (playerSet == null) {
            playerSet = this.getSyncStrategy().getPlayerSet((Entity)((CapabilityComponent)capabilityComponent).getHolder());
        }
        MessageSender.broadcast(playerSet, this.toMessage((CapabilityComponent)capabilityComponent));
    }

    @Override
    default public ClientboundEntityCapabilityMessage toMessage(C capabilityComponent) {
        return new ClientboundEntityCapabilityMessage(this.id(), ((Entity)((CapabilityComponent)capabilityComponent).getHolder()).getId(), capabilityComponent.toCompoundTag((HolderLookup.Provider)((Entity)((CapabilityComponent)capabilityComponent).getHolder()).registryAccess()));
    }

    public static interface Mutable<T extends Entity, C extends CapabilityComponent<T>>
    extends EntityCapabilityKey<T, C> {
        public Mutable<T, C> setSyncStrategy(SyncStrategy var1);

        public Mutable<T, C> setCopyStrategy(CopyStrategy var1);
    }
}

