/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.core.v1;

import fuzs.puzzleslib.api.client.core.v1.context.BlockColorsContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.core.v1.context.ClientTooltipComponentsContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntitySpectatorShadersContext;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemDecorationsContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.core.v1.context.ParticleProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderBuffersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderPipelinesContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import fuzs.puzzleslib.api.client.core.v1.context.SkullRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.SpecialBlockModelRenderersContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.core.proxy.ClientProxyImpl;
import fuzs.puzzleslib.impl.core.context.ModConstructorImpl;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.function.Consumers;

public interface ClientModConstructor {
    public static void construct(String modId, Supplier<ClientModConstructor> modConstructorSupplier) {
        ClientModConstructor.construct(ResourceLocationHelper.fromNamespaceAndPath(modId, "main"), modConstructorSupplier);
    }

    public static void construct(ResourceLocation resourceLocation, Supplier<ClientModConstructor> modConstructorSupplier) {
        PuzzlesLib.LOGGER.info("Constructing client components for {}", (Object)resourceLocation);
        ModConstructorImpl.construct(resourceLocation.getNamespace(), modConstructorSupplier, ClientProxyImpl.get()::getClientModConstructorImpl, Consumers.nop());
    }

    default public void onConstructMod() {
    }

    default public void onClientSetup() {
    }

    default public void onRegisterEntityRenderers(EntityRenderersContext context) {
    }

    default public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
    }

    default public void onRegisterClientTooltipComponents(ClientTooltipComponentsContext context) {
    }

    default public void onRegisterParticleProviders(ParticleProvidersContext context) {
    }

    default public void onRegisterMenuScreens(MenuScreensContext context) {
    }

    default public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
    }

    default public void onRegisterBlockStateResolver(BlockStateResolverContext context) {
    }

    default public void onRegisterItemDecorations(ItemDecorationsContext context) {
    }

    default public void onRegisterEntitySpectatorShaders(EntitySpectatorShadersContext context) {
    }

    default public void onRegisterItemModels(ItemModelsContext context) {
    }

    default public void onRegisterSpecialBlockModelRenderers(SpecialBlockModelRenderersContext context) {
    }

    default public void onRegisterSkullRenderers(SkullRenderersContext context) {
    }

    default public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
    }

    default public void onRegisterKeyMappings(KeyMappingsContext context) {
    }

    default public void onRegisterBlockRenderTypes(RenderTypesContext<Block> context) {
    }

    default public void onRegisterFluidRenderTypes(RenderTypesContext<Fluid> context) {
    }

    default public void onRegisterBlockColorProviders(BlockColorsContext context) {
    }

    default public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
    }

    default public void onRegisterRenderBuffers(RenderBuffersContext context) {
    }

    default public void onRegisterRenderPipelines(RenderPipelinesContext context) {
    }

    default public void onRegisterGuiLayers(GuiLayersContext context) {
    }
}

