/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.event.v1.gui;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

@Deprecated(forRemoval=true)
public final class RenderGuiLayerEvents {
    private static final List<ResourceLocation> VANILLA_GUI_LAYERS = new ArrayList<ResourceLocation>();
    public static final List<ResourceLocation> VANILLA_GUI_LAYERS_VIEW = Collections.unmodifiableList(VANILLA_GUI_LAYERS);
    public static final ResourceLocation CAMERA_OVERLAYS = RenderGuiLayerEvents.registerGuiLayer("camera_overlays");
    public static final ResourceLocation CROSSHAIR = RenderGuiLayerEvents.registerGuiLayer("crosshair");
    public static final ResourceLocation HOTBAR = RenderGuiLayerEvents.registerGuiLayer("hotbar");
    public static final ResourceLocation JUMP_METER = RenderGuiLayerEvents.registerGuiLayer("jump_meter");
    public static final ResourceLocation EXPERIENCE_BAR = RenderGuiLayerEvents.registerGuiLayer("experience_bar");
    public static final ResourceLocation PLAYER_HEALTH = RenderGuiLayerEvents.registerGuiLayer("player_health");
    public static final ResourceLocation ARMOR_LEVEL = RenderGuiLayerEvents.registerGuiLayer("armor_level");
    public static final ResourceLocation FOOD_LEVEL = RenderGuiLayerEvents.registerGuiLayer("food_level");
    public static final ResourceLocation VEHICLE_HEALTH = RenderGuiLayerEvents.registerGuiLayer("vehicle_health");
    public static final ResourceLocation AIR_LEVEL = RenderGuiLayerEvents.registerGuiLayer("air_level");
    public static final ResourceLocation SELECTED_ITEM_NAME = RenderGuiLayerEvents.registerGuiLayer("selected_item_name");
    public static final ResourceLocation SPECTATOR_TOOLTIP = RenderGuiLayerEvents.registerGuiLayer("spectator_tooltip");
    public static final ResourceLocation EXPERIENCE_LEVEL = RenderGuiLayerEvents.registerGuiLayer("experience_level");
    public static final ResourceLocation STATUS_EFFECTS = RenderGuiLayerEvents.registerGuiLayer("effects");
    public static final ResourceLocation BOSS_BAR = RenderGuiLayerEvents.registerGuiLayer("boss_overlay");
    public static final ResourceLocation SLEEP_OVERLAY = RenderGuiLayerEvents.registerGuiLayer("sleep_overlay");
    public static final ResourceLocation DEMO_TIMER = RenderGuiLayerEvents.registerGuiLayer("demo_overlay");
    public static final ResourceLocation DEBUG_OVERLAY = RenderGuiLayerEvents.registerGuiLayer("debug_overlay");
    public static final ResourceLocation SCOREBOARD = RenderGuiLayerEvents.registerGuiLayer("scoreboard_sidebar");
    public static final ResourceLocation OVERLAY_MESSAGE = RenderGuiLayerEvents.registerGuiLayer("overlay_message");
    public static final ResourceLocation TITLE = RenderGuiLayerEvents.registerGuiLayer("title");
    public static final ResourceLocation CHAT = RenderGuiLayerEvents.registerGuiLayer("chat");
    public static final ResourceLocation PLAYER_LIST = RenderGuiLayerEvents.registerGuiLayer("tab_list");
    public static final ResourceLocation SUBTITLES = RenderGuiLayerEvents.registerGuiLayer("subtitle_overlay");
    public static final ResourceLocation SAVING_INDICATOR = RenderGuiLayerEvents.registerGuiLayer("saving_indicator");

    private RenderGuiLayerEvents() {
    }

    public static EventInvoker<Before> before(ResourceLocation resourceLocation) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        return EventInvoker.lookup(Before.class, resourceLocation);
    }

    public static EventInvoker<After> after(ResourceLocation resourceLocation) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        return EventInvoker.lookup(After.class, resourceLocation);
    }

    private static ResourceLocation registerGuiLayer(String path) {
        return RenderGuiLayerEvents.registerGuiLayer(ResourceLocationHelper.withDefaultNamespace(path));
    }

    public static ResourceLocation registerGuiLayer(ResourceLocation resourceLocation) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        VANILLA_GUI_LAYERS.add(resourceLocation);
        return resourceLocation;
    }

    public static ResourceLocation registerGuiLayer(ResourceLocation resourceLocation, ResourceLocation otherResourceLocation) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        Objects.requireNonNull(otherResourceLocation, "other resource location is null");
        int resourceLocationIndex = VANILLA_GUI_LAYERS.indexOf(resourceLocation);
        int otherResourceLocationIndex = VANILLA_GUI_LAYERS.indexOf(otherResourceLocation);
        if (resourceLocationIndex != -1 && otherResourceLocationIndex == -1) {
            VANILLA_GUI_LAYERS.add(resourceLocationIndex + 1, otherResourceLocation);
            return otherResourceLocation;
        }
        if (resourceLocationIndex == -1 && otherResourceLocationIndex != -1) {
            VANILLA_GUI_LAYERS.add(otherResourceLocationIndex, resourceLocation);
            return resourceLocation;
        }
        throw new RuntimeException("Invalid resource location indices: " + String.valueOf(resourceLocation) + "=" + resourceLocationIndex + ", " + String.valueOf(otherResourceLocation) + "=" + otherResourceLocationIndex);
    }

    @FunctionalInterface
    public static interface Before {
        public EventResult onBeforeRenderGuiLayer(Gui var1, GuiGraphics var2, DeltaTracker var3);
    }

    @FunctionalInterface
    public static interface After {
        public void onAfterRenderGuiLayer(Gui var1, GuiGraphics var2, DeltaTracker var3);
    }
}

