/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public final class ContainerSerializationHelper
extends ContainerHelper {
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_SLOT = "Slot";

    private ContainerSerializationHelper() {
    }

    public static CompoundTag saveAllItems(CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider lookupProvider) {
        return ContainerHelper.saveAllItems((CompoundTag)tag, items, (HolderLookup.Provider)lookupProvider);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, Container container, HolderLookup.Provider lookupProvider) {
        return ContainerSerializationHelper.saveAllItems(tag, container, true, lookupProvider);
    }

    public static CompoundTag saveAllItems(String tagKey, CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider lookupProvider) {
        return ContainerSerializationHelper.saveAllItems(tagKey, tag, items, true, lookupProvider);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, Container container, boolean saveEmpty, HolderLookup.Provider lookupProvider) {
        return ContainerSerializationHelper.saveAllItems(TAG_ITEMS, tag, container.getContainerSize(), arg_0 -> ((Container)container).getItem(arg_0), saveEmpty, lookupProvider);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, NonNullList<ItemStack> items, boolean saveEmpty, HolderLookup.Provider lookupProvider) {
        return ContainerHelper.saveAllItems((CompoundTag)tag, items, (boolean)saveEmpty, (HolderLookup.Provider)lookupProvider);
    }

    public static CompoundTag saveAllItems(String tagKey, CompoundTag tag, NonNullList<ItemStack> items, boolean saveEmpty, HolderLookup.Provider lookupProvider) {
        return ContainerSerializationHelper.saveAllItems(tagKey, tag, items.size(), arg_0 -> items.get(arg_0), saveEmpty, lookupProvider);
    }

    public static CompoundTag saveAllItems(String tagKey, CompoundTag tag, int size, IntFunction<ItemStack> itemGetter, boolean saveEmpty, HolderLookup.Provider lookupProvider) {
        ListTag listTag = ContainerSerializationHelper.createTag(size, itemGetter, lookupProvider);
        if (!listTag.isEmpty() || saveEmpty) {
            tag.put(tagKey, (Tag)listTag);
        }
        return tag;
    }

    public static ListTag createTag(int size, IntFunction<ItemStack> itemGetter, HolderLookup.Provider lookupProvider) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = itemGetter.apply(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte(TAG_SLOT, (byte)i);
            listTag.add((Object)itemStack.save(lookupProvider, (Tag)compoundTag));
        }
        return listTag;
    }

    public static void loadAllItems(CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider lookupProvider) {
        ContainerHelper.loadAllItems((CompoundTag)tag, items, (HolderLookup.Provider)lookupProvider);
    }

    public static void loadAllItems(CompoundTag tag, Container container, HolderLookup.Provider lookupProvider) {
        ContainerSerializationHelper.loadAllItems(TAG_ITEMS, tag, container.getContainerSize(), (stack, value) -> container.setItem(value, stack), lookupProvider);
    }

    public static void loadAllItems(String tagKey, CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider lookupProvider) {
        ContainerSerializationHelper.loadAllItems(tagKey, tag, items.size(), (stack, value) -> items.set(value, stack), lookupProvider);
    }

    public static void loadAllItems(String tagKey, CompoundTag tag, int size, ObjIntConsumer<ItemStack> itemSetter, HolderLookup.Provider lookupProvider) {
        ListTag listTag = tag.getListOrEmpty(tagKey);
        ContainerSerializationHelper.fromTag(listTag, size, itemSetter, lookupProvider);
    }

    public static void fromTag(ListTag listTag, int size, ObjIntConsumer<ItemStack> itemSetter, HolderLookup.Provider lookupProvider) {
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.getCompoundOrEmpty(i);
            int slot = compoundTag.getByteOr(TAG_SLOT, (byte)0) & 0xFF;
            if (slot >= size) continue;
            itemSetter.accept(ItemStack.parse((HolderLookup.Provider)lookupProvider, (Tag)compoundTag).orElse(ItemStack.EMPTY), slot);
        }
    }
}

