/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeProvider
extends RecipeProvider
implements DataProvider {
    static final RegistryAccess EMPTY_REGISTRY_ACCESS = new RegistryAccess.ImmutableRegistryAccess(List.of(new MappedRegistry(Registries.ITEM, Lifecycle.stable())));
    static final RecipeOutput EMPTY_RECIPE_OUTPUT = new RecipeOutput(){

        public void accept(ResourceKey<Recipe<?>> resourceKey, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder) {
            throw new UnsupportedOperationException();
        }

        public Advancement.Builder advancement() {
            throw new UnsupportedOperationException();
        }

        public void includeRootAdvancement() {
            throw new UnsupportedOperationException();
        }
    };
    private static final Map<BlockFamily.Variant, BiFunction<ItemLike, ItemLike, RecipeBuilder>> STONECUTTING_BUILDERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.CHISELED, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)itemLike2), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike)).put((Object)BlockFamily.Variant.CUT, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)itemLike2), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike)).put((Object)BlockFamily.Variant.SLAB, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)itemLike2), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike, (int)2)).put((Object)BlockFamily.Variant.STAIRS, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)itemLike2), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike)).put((Object)BlockFamily.Variant.POLISHED, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)itemLike2), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike)).put((Object)BlockFamily.Variant.WALL, (itemLike, itemLike2) -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)itemLike2), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)itemLike)).build();
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> registries;
    protected final String modId;

    public AbstractRecipeProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput(), context.getRegistries());
    }

    public AbstractRecipeProvider(String modId, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super((HolderLookup.Provider)EMPTY_REGISTRY_ACCESS, EMPTY_RECIPE_OUTPUT);
        this.packOutput = packOutput;
        this.registries = registries;
        this.modId = modId;
    }

    @Nullable
    protected static <T> JsonElement searchAndReplaceValue(@Nullable JsonElement jsonElement, T searchFor, T replaceWith) {
        block10: {
            block11: {
                Objects.requireNonNull(searchFor, "search for is null");
                Objects.requireNonNull(replaceWith, "replace with is null");
                if (jsonElement == null || jsonElement.isJsonNull()) break block10;
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                    if (jsonPrimitive.isNumber()) {
                        if (searchFor.equals(jsonPrimitive.getAsNumber())) {
                            return new JsonPrimitive((Number)replaceWith);
                        }
                    } else if (jsonPrimitive.isBoolean()) {
                        if (searchFor.equals(jsonPrimitive.getAsBoolean())) {
                            return new JsonPrimitive((Boolean)replaceWith);
                        }
                    } else if (jsonPrimitive.isString() && searchFor.toString().equals(jsonPrimitive.getAsString())) {
                        return new JsonPrimitive(replaceWith.toString());
                    }
                    return jsonElement;
                }
                if (!jsonElement.isJsonArray()) break block11;
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    jsonArray.set(i, AbstractRecipeProvider.searchAndReplaceValue(jsonArray.get(i), searchFor, replaceWith));
                }
                break block10;
            }
            if (!jsonElement.isJsonObject()) break block10;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                entry.setValue(AbstractRecipeProvider.searchAndReplaceValue((JsonElement)entry.getValue(), searchFor, replaceWith));
            }
        }
        return jsonElement;
    }

    public void generateForBlockFamilies(Stream<BlockFamily> blockFamilies) {
        blockFamilies.filter(BlockFamily::shouldGenerateRecipe).forEach(blockFamily -> this.generateRecipes((BlockFamily)blockFamily, FeatureFlags.DEFAULT_FLAGS));
    }

    public void generateRecipes(BlockFamily blockFamily, FeatureFlagSet requiredFeatures) {
        super.generateRecipes(blockFamily, requiredFeatures);
        blockFamily.getVariants().forEach((variant, block) -> {
            if (block.requiredFeatures().isSubsetOf(requiredFeatures)) {
                BiFunction<ItemLike, ItemLike, RecipeBuilder> biFunction = STONECUTTING_BUILDERS.get(variant);
                Block itemLike = this.getBaseBlock(blockFamily, (BlockFamily.Variant)variant);
                if (biFunction != null) {
                    RecipeBuilder recipeBuilder = biFunction.apply((ItemLike)block, (ItemLike)itemLike);
                    recipeBuilder.unlockedBy(blockFamily.getRecipeUnlockedBy().orElseGet(() -> AbstractRecipeProvider.lambda$generateRecipes$7((ItemLike)itemLike)), this.has((ItemLike)itemLike));
                    recipeBuilder.save(this.output, AbstractRecipeProvider.getStonecuttingRecipeName((ItemLike)block, (ItemLike)itemLike));
                }
            }
        });
    }

    public void stair(RecipeCategory recipeCategory, ItemLike resultItem, ItemLike ingredientItem) {
        this.stairBuilder(recipeCategory, resultItem, Ingredient.of((ItemLike)ingredientItem)).unlockedBy(AbstractRecipeProvider.getHasName((ItemLike)ingredientItem), this.has(ingredientItem)).save(this.output);
    }

    public RecipeBuilder stairBuilder(RecipeCategory recipeCategory, ItemLike resultItem, Ingredient ingredient) {
        return this.shaped(recipeCategory, resultItem, 4).define(Character.valueOf('#'), ingredient).pattern("#  ").pattern("## ").pattern("###");
    }

    public void metalCooking(ItemLike resultItem, ItemLike ingredientItem, float experience) {
        this.metalCooking(resultItem, ingredientItem, experience, 200);
    }

    public void metalCooking(ItemLike resultItem, ItemLike ingredientItem, float experience, int baseCookingTime) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)ingredientItem), (RecipeCategory)RecipeCategory.MISC, (ItemLike)resultItem, (float)experience, (int)baseCookingTime).unlockedBy(AbstractRecipeProvider.getHasName((ItemLike)ingredientItem), this.has(ingredientItem)).save(this.output);
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike)ingredientItem), (RecipeCategory)RecipeCategory.MISC, (ItemLike)resultItem, (float)experience, (int)(baseCookingTime / 2)).unlockedBy(AbstractRecipeProvider.getHasName((ItemLike)ingredientItem), this.has(ingredientItem)).save(this.output, AbstractRecipeProvider.getBlastingRecipeName((ItemLike)resultItem));
    }

    public void foodCooking(ItemLike resultItem, ItemLike ingredientItem) {
        this.foodCooking(resultItem, ingredientItem, 0.35f, 200);
    }

    public void foodCooking(ItemLike resultItem, ItemLike ingredientItem, float experienceReward, int baseCookingTime) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)ingredientItem), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)resultItem, (float)experienceReward, (int)baseCookingTime).unlockedBy(AbstractRecipeProvider.getHasName((ItemLike)ingredientItem), this.has(ingredientItem)).save(this.output);
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)ingredientItem), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)resultItem, (float)experienceReward, (int)(baseCookingTime / 2)).unlockedBy(AbstractRecipeProvider.getHasName((ItemLike)ingredientItem), this.has(ingredientItem)).save(this.output, AbstractRecipeProvider.getCraftingMethodRecipeName(resultItem, RecipeSerializer.SMOKING_RECIPE));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike)ingredientItem), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)resultItem, (float)experienceReward, (int)(baseCookingTime * 3)).unlockedBy(AbstractRecipeProvider.getHasName((ItemLike)ingredientItem), this.has(ingredientItem)).save(this.output, AbstractRecipeProvider.getCraftingMethodRecipeName(resultItem, RecipeSerializer.CAMPFIRE_COOKING_RECIPE));
    }

    public RecipeBuilder stonecutterResultFromBaseBuilder(RecipeCategory recipeCategory, ItemLike resultItem, Ingredient ingredient) {
        return this.stonecutterResultFromBaseBuilder(recipeCategory, resultItem, ingredient, 1);
    }

    public RecipeBuilder stonecutterResultFromBaseBuilder(RecipeCategory recipeCategory, ItemLike resultItem, Ingredient ingredient, int count) {
        return SingleItemRecipeBuilder.stonecutting((Ingredient)ingredient, (RecipeCategory)recipeCategory, (ItemLike)resultItem, (int)count);
    }

    public void smithing(RecipeCategory recipeCategory, ItemLike resultItem, ItemLike templateItem, ItemLike baseItem, ItemLike materialItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)templateItem), (Ingredient)Ingredient.of((ItemLike)baseItem), (Ingredient)Ingredient.of((ItemLike)materialItem), (RecipeCategory)recipeCategory, (Item)resultItem.asItem()).unlocks(AbstractRecipeProvider.getHasName((ItemLike)materialItem), this.has(materialItem)).save(this.output, AbstractRecipeProvider.getSmithingRecipeName(resultItem));
    }

    public void waxing(ItemLike resultItem, ItemLike ingredientItem) {
        ShapelessRecipeBuilder.shapeless((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)resultItem).requires(ingredientItem).requires((ItemLike)Items.HONEYCOMB).group(AbstractRecipeProvider.getItemName((ItemLike)resultItem)).unlockedBy(AbstractRecipeProvider.getHasName((ItemLike)ingredientItem), this.has(ingredientItem)).save(this.output, AbstractRecipeProvider.getConversionRecipeName((ItemLike)resultItem, (ItemLike)Items.HONEYCOMB));
    }

    public static String getCraftingMethodRecipeName(ItemLike resultItem, RecipeSerializer<?> recipeSerializer) {
        ResourceLocation resourceLocation = BuiltInRegistries.RECIPE_SERIALIZER.getKey(recipeSerializer);
        Objects.requireNonNull(resourceLocation, "resource location is null");
        return AbstractRecipeProvider.getCraftingMethodRecipeName(resultItem, resourceLocation.getPath());
    }

    public static String getCraftingMethodRecipeName(ItemLike resultItem, String craftingMethod) {
        return AbstractRecipeProvider.getItemName((ItemLike)resultItem) + "_from_" + craftingMethod;
    }

    public static String getStonecuttingRecipeName(ItemLike resultItem, ItemLike material) {
        return AbstractRecipeProvider.getConversionRecipeName((ItemLike)resultItem, (ItemLike)material) + "_stonecutting";
    }

    public static String getSmithingRecipeName(ItemLike resultItem) {
        return AbstractRecipeProvider.getItemName((ItemLike)resultItem) + "_smithing";
    }

    public static String getHasName(TagKey<Item> tagKey) {
        return "has_" + tagKey.location().getPath();
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return ((CompletableFuture)this.registries.thenCompose(registries -> {
            ArrayList completableFutures = new ArrayList();
            RecipeOutputImpl recipeOutput = new RecipeOutputImpl(output, (HolderLookup.Provider)registries, completableFutures::add);
            this.injectRegistries((HolderLookup.Provider)registries, recipeOutput);
            this.addRecipes(recipeOutput);
            return CompletableFuture.allOf((CompletableFuture[])completableFutures.toArray(CompletableFuture[]::new));
        })).thenRun(() -> this.injectRegistries((HolderLookup.Provider)EMPTY_REGISTRY_ACCESS, EMPTY_RECIPE_OUTPUT));
    }

    private void injectRegistries(HolderLookup.Provider registries, RecipeOutput recipeOutput) {
        ((RecipeProvider)this).registries = registries;
        this.items = registries.lookupOrThrow(Registries.ITEM);
        this.output = recipeOutput;
    }

    public final HolderLookup.Provider registries() {
        Preconditions.checkState((((RecipeProvider)this).registries != EMPTY_REGISTRY_ACCESS ? 1 : 0) != 0, (Object)"registry access is empty");
        return ((RecipeProvider)this).registries;
    }

    public final HolderGetter<Item> items() {
        Preconditions.checkState((((RecipeProvider)this).registries != EMPTY_REGISTRY_ACCESS ? 1 : 0) != 0, (Object)"registry access is empty");
        return this.items;
    }

    public void buildRecipes() {
        throw new UnsupportedOperationException();
    }

    public abstract void addRecipes(RecipeOutput var1);

    public String getName() {
        return "Recipes";
    }

    private static /* synthetic */ String lambda$generateRecipes$7(ItemLike itemLike) {
        return AbstractRecipeProvider.getHasName((ItemLike)itemLike);
    }

    private class RecipeOutputImpl
    implements RecipeOutput {
        private final CachedOutput output;
        private final PackOutput.PathProvider recipePathProvider;
        private final PackOutput.PathProvider advancementPathProvider;
        private final HolderLookup.Provider registries;
        private final Consumer<CompletableFuture<?>> consumer;
        private final Set<ResourceKey<Recipe<?>>> recipes = new HashSet();

        public RecipeOutputImpl(CachedOutput output, HolderLookup.Provider registries, Consumer<CompletableFuture<?>> consumer) {
            this.output = output;
            this.recipePathProvider = AbstractRecipeProvider.this.packOutput.createRegistryElementsPathProvider(Registries.RECIPE);
            this.advancementPathProvider = AbstractRecipeProvider.this.packOutput.createRegistryElementsPathProvider(Registries.ADVANCEMENT);
            this.registries = registries;
            this.consumer = consumer;
        }

        public void accept(ResourceKey<Recipe<?>> resourceKey, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder) {
            ResourceKey originalResourceKey = resourceKey;
            ResourceLocation resourceLocation = ResourceLocationHelper.fromNamespaceAndPath(AbstractRecipeProvider.this.modId, resourceKey.location().getPath());
            if (!this.recipes.add(resourceKey = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceLocation))) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(resourceKey));
            }
            this.consumer.accept(DataProvider.saveStable((CachedOutput)this.output, (HolderLookup.Provider)this.registries, (Codec)Recipe.CODEC, recipe, (Path)this.recipePathProvider.json(resourceKey.location())));
            if (advancementHolder != null) {
                RegistryOps registryOps = this.registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
                JsonElement jsonElement = (JsonElement)Advancement.CODEC.encodeStart((DynamicOps)registryOps, (Object)advancementHolder.value()).getOrThrow();
                jsonElement = AbstractRecipeProvider.searchAndReplaceValue(jsonElement, originalResourceKey, resourceKey);
                ResourceLocation advancementLocation = ResourceLocationHelper.fromNamespaceAndPath(AbstractRecipeProvider.this.modId, advancementHolder.id().getPath());
                this.consumer.accept(DataProvider.saveStable((CachedOutput)this.output, (JsonElement)jsonElement, (Path)this.advancementPathProvider.json(advancementLocation)));
            }
        }

        public Advancement.Builder advancement() {
            return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
        }

        public void includeRootAdvancement() {
            throw new UnsupportedOperationException();
        }
    }
}

