/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3;

import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.CommonSetupCallback;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public final class LootContextKeySetFactory {
    private LootContextKeySetFactory() {
    }

    public static ContextKeySet registerContextKeySet(ResourceLocation resourceLocation, Consumer<ContextKeySet.Builder> builderConsumer) {
        ContextKeySet.Builder builder = new ContextKeySet.Builder();
        builderConsumer.accept(builder);
        ContextKeySet contextKeySet = builder.build();
        if (ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            LootContextKeySetFactory.registerContextKeySet(resourceLocation, contextKeySet);
        } else {
            CommonSetupCallback.EVENT.register(() -> LootContextKeySetFactory.registerContextKeySet(resourceLocation, contextKeySet));
        }
        return contextKeySet;
    }

    static void registerContextKeySet(ResourceLocation resourceLocation, ContextKeySet contextKeySet) {
        if (LootContextParamSets.REGISTRY.put((Object)resourceLocation, (Object)contextKeySet) != null) {
            throw new IllegalStateException("Loot context key set " + String.valueOf(resourceLocation) + " is already registered");
        }
    }
}

