/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v4.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.time.Instant;
import java.util.BitSet;
import java.util.Date;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public final class ExtraStreamCodecs {
    public static final StreamCodec<ByteBuf, Character> CHAR = StreamCodec.of((buf, character) -> buf.writeChar((int)character.charValue()), ByteBuf::readChar);
    public static final StreamCodec<FriendlyByteBuf, Date> DATE = StreamCodec.of(FriendlyByteBuf::writeDate, FriendlyByteBuf::readDate);
    public static final StreamCodec<FriendlyByteBuf, Instant> INSTANT = StreamCodec.of(FriendlyByteBuf::writeInstant, FriendlyByteBuf::readInstant);
    public static final StreamCodec<FriendlyByteBuf, BlockHitResult> BLOCK_HIT_RESULT = StreamCodec.of(FriendlyByteBuf::writeBlockHitResult, FriendlyByteBuf::readBlockHitResult);
    public static final StreamCodec<FriendlyByteBuf, BitSet> BIT_SET = StreamCodec.of(FriendlyByteBuf::writeBitSet, FriendlyByteBuf::readBitSet);
    public static final StreamCodec<ByteBuf, BlockState> BLOCK_STATE = ByteBufCodecs.VAR_INT.map(Block::stateById, Block::getId);
    @Deprecated(forRemoval=true)
    public static final StreamCodec<ByteBuf, ResourceKey<?>> DIRECT_RESOURCE_KEY = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ResourceKey::registry, (StreamCodec)ResourceLocation.STREAM_CODEC, ResourceKey::location, (registry, location) -> ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)registry), (ResourceLocation)location));
    @Deprecated(forRemoval=true)
    public static final StreamCodec<FriendlyByteBuf, FriendlyByteBuf> FRIENDLY_BYTE_BUF = new StreamCodec<FriendlyByteBuf, FriendlyByteBuf>(){

        public FriendlyByteBuf decode(FriendlyByteBuf buf) {
            FriendlyByteBuf newBuf = new FriendlyByteBuf(Unpooled.buffer());
            newBuf.writeBytes(buf.copy());
            buf.skipBytes(buf.readableBytes());
            return newBuf;
        }

        public void encode(FriendlyByteBuf buf, FriendlyByteBuf toEncode) {
            buf.writeBytes(toEncode.copy());
            toEncode.release();
        }
    };
    @Deprecated(forRemoval=true)
    public static final StreamCodec<RegistryFriendlyByteBuf, RegistryFriendlyByteBuf> REGISTRY_FRIENDLY_BYTE_BUF = new StreamCodec<RegistryFriendlyByteBuf, RegistryFriendlyByteBuf>(){

        public RegistryFriendlyByteBuf decode(RegistryFriendlyByteBuf buf) {
            RegistryFriendlyByteBuf newBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), buf.registryAccess());
            newBuf.writeBytes(buf.copy());
            buf.skipBytes(buf.readableBytes());
            return newBuf;
        }

        public void encode(RegistryFriendlyByteBuf buf, RegistryFriendlyByteBuf toEncode) {
            buf.writeBytes(toEncode.copy());
            toEncode.release();
        }
    };

    private ExtraStreamCodecs() {
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> fromEnum(Class<E> clazz) {
        return ExtraStreamCodecs.fromEnum(clazz, Enum::ordinal);
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> fromEnum(Class<E> clazz, ToIntFunction<E> keyExtractor) {
        IntFunction idMapper = ByIdMap.continuous(keyExtractor, (Object[])((Enum[])clazz.getEnumConstants()), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        return ByteBufCodecs.idMapper((IntFunction)idMapper, keyExtractor);
    }

    @Deprecated(forRemoval=true)
    public static Component readComponent(RegistryFriendlyByteBuf buf) {
        return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buf);
    }

    @Deprecated(forRemoval=true)
    public static void writeComponent(RegistryFriendlyByteBuf buf, Component component) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)component);
    }

    @Deprecated(forRemoval=true)
    public static ItemStack readItem(RegistryFriendlyByteBuf buf) {
        return (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
    }

    @Deprecated(forRemoval=true)
    public static void writeItem(RegistryFriendlyByteBuf buf, ItemStack itemStack) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)itemStack);
    }
}

