/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.attachment.builder;

import fuzs.puzzleslib.api.attachment.v4.DataAttachmentRegistry;
import fuzs.puzzleslib.api.event.v1.entity.player.AfterChangeDimensionCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerNetworkEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTrackingEvents;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.impl.attachment.AttachmentTypeAdapter;
import fuzs.puzzleslib.impl.attachment.ClientboundEntityDataAttachmentMessage;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public interface EntityDataAttachmentBuilder<V>
extends DataAttachmentRegistry.EntityBuilder<V> {
    @Nullable
    default public BiConsumer<Entity, V> getSynchronizer(AttachmentTypeAdapter<Entity, V> attachmentType, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec, @Nullable Function<Entity, PlayerSet> synchronizationTargets) {
        if (streamCodec == null) {
            return null;
        }
        CustomPacketPayload.Type payloadType = new CustomPacketPayload.Type(attachmentType.resourceLocation());
        this.registerPayloadHandlers(attachmentType, payloadType, streamCodec);
        this.registerEventHandlers(attachmentType, payloadType, synchronizationTargets);
        return this.getDefaultSynchronizer(attachmentType, payloadType, synchronizationTargets);
    }

    public void registerPayloadHandlers(AttachmentTypeAdapter<Entity, V> var1, CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> var2, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, V> var3);

    private void registerEventHandlers(AttachmentTypeAdapter<Entity, V> attachmentType, CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> payloadType, @Nullable Function<Entity, PlayerSet> synchronizationTargets) {
        PlayerNetworkEvents.LOGGED_IN.register(serverPlayer -> this.broadcast(attachmentType, payloadType, serverPlayer));
        AfterChangeDimensionCallback.EVENT.register((serverPlayer, from, to) -> this.broadcast(attachmentType, payloadType, serverPlayer));
        PlayerCopyEvents.RESPAWN.register((serverPlayer, originalStillAlive) -> this.broadcast(attachmentType, payloadType, serverPlayer));
        if (synchronizationTargets != null) {
            PlayerTrackingEvents.START.register((trackedEntity, serverPlayer) -> this.broadcast(attachmentType, payloadType, trackedEntity, PlayerSet.ofPlayer(serverPlayer)));
        }
    }

    private BiConsumer<Entity, V> getDefaultSynchronizer(AttachmentTypeAdapter<Entity, V> attachmentType, CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> payloadType, @Nullable Function<Entity, PlayerSet> synchronizationTargets) {
        return (entity, value) -> {
            PlayerSet playerSet = synchronizationTargets != null ? (PlayerSet)synchronizationTargets.apply((Entity)entity) : PlayerSet.ofEntity(entity);
            this.broadcast(attachmentType, payloadType, (Entity)entity, playerSet, (V)value);
        };
    }

    private void broadcast(AttachmentTypeAdapter<Entity, V> attachmentType, CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> payloadType, ServerPlayer serverPlayer) {
        this.broadcast(attachmentType, payloadType, (Entity)serverPlayer, PlayerSet.ofPlayer(serverPlayer));
    }

    private void broadcast(AttachmentTypeAdapter<Entity, V> attachmentType, CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> payloadType, Entity entity, PlayerSet playerSet) {
        if (attachmentType.hasData(entity)) {
            this.broadcast(attachmentType, payloadType, entity, playerSet, attachmentType.getData(entity));
        }
    }

    private void broadcast(AttachmentTypeAdapter<Entity, V> attachmentType, CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> payloadType, Entity entity, PlayerSet playerSet, @Nullable V value) {
        ClientboundEntityDataAttachmentMessage<V> message = new ClientboundEntityDataAttachmentMessage<V>(attachmentType, payloadType, entity.getId(), Optional.ofNullable(value));
        MessageSender.broadcast(playerSet, message);
    }
}

