/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import fuzs.puzzleslib.api.client.event.v1.AddResourcePackReloadListenersCallback;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ClientPlayerNetworkEvents;
import fuzs.puzzleslib.api.client.gui.v2.GuiHeightHelper;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.impl.client.config.ConfigTranslationsManager;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class PuzzlesLibClient
implements ClientModConstructor {
    @Override
    public void onConstructMod() {
        PuzzlesLibClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        AddResourcePackReloadListenersCallback.EVENT.register(ConfigTranslationsManager::onAddResourcePackReloadListeners);
        ClientPlayerNetworkEvents.LOGGED_OUT.register((player, multiPlayerGameMode, connection) -> ModContext.clearPresentServerside());
    }

    @Override
    public void onRegisterGuiLayers(GuiLayersContext context) {
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike()) {
            context.replaceGuiLayer(GuiLayersContext.SELECTED_ITEM_NAME, layer -> (guiGraphics, deltaTracker) -> {
                Gui gui = Minecraft.getInstance().gui;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 59.0f - Math.max(59.0f, (float)GuiHeightHelper.getMaxHeight(gui)), 0.0f);
                layer.render(guiGraphics, deltaTracker);
                guiGraphics.pose().popPose();
            });
            context.replaceGuiLayer(GuiLayersContext.OVERLAY_MESSAGE, layer -> (guiGraphics, deltaTracker) -> {
                Gui gui = Minecraft.getInstance().gui;
                guiGraphics.pose().pushPose();
                PoseStack poseStack = guiGraphics.pose();
                int n = GuiHeightHelper.getMaxHeight(gui);
                Objects.requireNonNull(gui.minecraft.font);
                poseStack.translate(0.0f, 68.0f - Math.max(68.0f, (float)(n + 9)), 0.0f);
                layer.render(guiGraphics, deltaTracker);
                guiGraphics.pose().popPose();
            });
        }
    }
}

