/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.config;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class ConfigTranslationsManager {
    public static final Map<String, String> TRANSLATIONS = new ConcurrentHashMap<String, String>();

    private ConfigTranslationsManager() {
    }

    public static void onAddResourcePackReloadListeners(BiConsumer<ResourceLocation, PreparableReloadListener> consumer) {
        consumer.accept(PuzzlesLibMod.id("config_translations"), (PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
            Language patt0$temp = Language.getInstance();
            if (patt0$temp instanceof ClientLanguage) {
                ClientLanguage clientLanguage = (ClientLanguage)patt0$temp;
                if (!(clientLanguage.storage instanceof HashMap)) {
                    clientLanguage.storage = new HashMap(clientLanguage.storage);
                }
                TRANSLATIONS.forEach(clientLanguage.storage::putIfAbsent);
            }
        }));
    }

    public static void addModConfig(String modId, String configType, String fileName, ModConfigSpec configSpec) {
        ConfigTranslationsManager.addConfigTitle(modId);
        ConfigTranslationsManager.addConfigFile(modId, fileName, configType);
        ConfigTranslationsManager.addConfigValues(modId, configSpec.getSpec(), new ArrayList<String>(), arg_0 -> ((ModConfigSpec)configSpec).getLevelComment(arg_0));
    }

    static void addConfigValues(String modId, UnmodifiableConfig config, List<String> path, Function<List<String>, @Nullable String> levelCommentGetter) {
        for (UnmodifiableConfig.Entry entry : config.entrySet()) {
            String comment;
            ConfigTranslationsManager.addConfigValue(modId, entry.getKey());
            Object object = entry.getValue();
            if (object instanceof ModConfigSpec.ValueSpec) {
                ModConfigSpec.ValueSpec valueSpec = (ModConfigSpec.ValueSpec)object;
                comment = valueSpec.getComment();
            } else if (entry.getValue() instanceof UnmodifiableConfig) {
                path = new ArrayList<String>(path);
                path.add(entry.getKey());
                comment = levelCommentGetter.apply(path);
                ConfigTranslationsManager.addConfigValues(modId, (UnmodifiableConfig)entry.getValue(), path, levelCommentGetter);
            } else {
                comment = null;
            }
            ConfigTranslationsManager.addConfigValueComment(modId, entry.getKey(), comment);
            ConfigTranslationsManager.addConfigValueButton(modId, entry.getKey());
        }
    }

    public static void addConfigTitle(String modId) {
        TRANSLATIONS.put(modId + ".configuration.title", "%s Configuration");
    }

    public static void addConfigFile(String modId, String fileName, String configType) {
        configType = ConfigTranslationsManager.getConfigTypeFromFileName(fileName).orElse(configType);
        configType = ConfigTranslationsManager.getCapitalizedString(configType);
        fileName = fileName.replaceAll("[^a-zA-Z0-9]+", ".").replaceFirst("^\\.", "").replaceFirst("\\.$", "").toLowerCase();
        TRANSLATIONS.put(modId + ".configuration.section." + fileName, "%s " + configType + " Settings");
        TRANSLATIONS.put(modId + ".configuration.section." + fileName + ".title", "%s " + configType + " Configuration");
    }

    static Optional<String> getConfigTypeFromFileName(String fileName) {
        int startIndex = fileName.lastIndexOf(45);
        int endIndex = fileName.lastIndexOf(46);
        if (startIndex != -1 && endIndex != -1 && startIndex < endIndex) {
            return Optional.of(fileName.substring(startIndex + 1, endIndex));
        }
        return Optional.empty();
    }

    public static void addConfigValue(String modId, String valueName) {
        Objects.requireNonNull(valueName, "value name is null");
        ConfigTranslationsManager.addConfigValue(modId, Collections.singletonList(valueName));
    }

    public static void addConfigValue(String modId, List<String> valuePath) {
        TRANSLATIONS.put(modId + ".configuration." + valuePath.getLast(), ConfigTranslationsManager.getCapitalizedString(valuePath.getLast()));
    }

    public static void addConfigValueComment(String modId, String valueName, @Nullable String comment) {
        Objects.requireNonNull(valueName, "value name is null");
        ConfigTranslationsManager.addConfigValueComment(modId, Collections.singletonList(valueName), comment != null ? Arrays.asList(comment.split("\\R")) : Collections.emptyList());
    }

    public static void addConfigValueComment(String modId, List<String> valuePath, List<String> comments) {
        String value = String.join((CharSequence)System.lineSeparator(), ConfigTranslationsManager.getStylizedStrings(comments));
        TRANSLATIONS.put(modId + ".configuration." + valuePath.getLast() + ".tooltip", value);
    }

    public static void addConfigValueButton(String modId, String valueName) {
        Objects.requireNonNull(valueName, "value name is null");
        ConfigTranslationsManager.addConfigValueButton(modId, Collections.singletonList(valueName));
    }

    public static void addConfigValueButton(String modId, List<String> valuePath) {
        TRANSLATIONS.put(valuePath.getLast() + ".button", "Edit...");
        TRANSLATIONS.put(modId + ".configuration." + valuePath.getLast() + ".button", "Edit...");
    }

    static String getCapitalizedString(String s) {
        String[] strings = s.toLowerCase().split("[\\s_]+");
        StringJoiner joiner = new StringJoiner(" ");
        for (String string : strings) {
            joiner.add(StringUtils.capitalize((String)string));
        }
        return joiner.toString().replace(" And ", " & ").replace(" Or ", " / ");
    }

    static List<String> getStylizedStrings(List<String> strings) {
        strings = new ArrayList<String>(strings);
        for (int i = 0; i < strings.size(); ++i) {
            ChatFormatting chatFormatting = i % 2 == 0 ? ChatFormatting.YELLOW : ChatFormatting.GOLD;
            strings.set(i, String.valueOf(chatFormatting) + strings.get(i) + String.valueOf(ChatFormatting.RESET));
        }
        return strings;
    }
}

