/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content;

import java.nio.file.Path;
import java.util.Scanner;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.Settings;
import net.minecraft.world.level.GameType;
import org.slf4j.Logger;

public final class ServerPropertiesHelper {
    private ServerPropertiesHelper() {
    }

    public static DedicatedServerProperties createDedicatedServerProperties(Path path, final Logger logger) {
        return new DedicatedServerProperties(Settings.loadFromFile((Path)path)){

            DedicatedServerProperties setProperties() {
                String input;
                this.properties.put("online-mode", String.valueOf(false));
                this.properties.put("gamemode", GameType.CREATIVE.getName());
                this.properties.put("enable-command-block", String.valueOf(true));
                this.properties.put("max-players", String.valueOf(4));
                this.properties.put("spawn-protection", String.valueOf(0));
                this.properties.put("view-distance", String.valueOf(16));
                Scanner scanner = new Scanner(System.in);
                do {
                    logger.warn("Invalid server ip address!");
                    System.out.print("server-ip=");
                } while (!(input = scanner.next()).matches("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$"));
                this.properties.put("server-ip", input);
                return new DedicatedServerProperties(this.properties);
            }
        }.setProperties();
    }
}

