/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.init;

import fuzs.puzzleslib.api.util.v1.HSV;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;

public class DyedSpawnEggItem
extends SpawnEggItem {
    private final int backgroundColor;
    private final int highlightColor;

    public DyedSpawnEggItem(EntityType<? extends Mob> defaultType, int backgroundColor, int highlightColor, Item.Properties properties) {
        super(defaultType, properties);
        this.backgroundColor = backgroundColor;
        this.highlightColor = highlightColor;
    }

    public int backgroundColor() {
        return this.backgroundColor;
    }

    public int highlightColor() {
        return this.highlightColor;
    }

    public static int generateHighlightColor(int backgroundColor) {
        int hsv = HSV.rgbToHsv(ARGB.redFloat((int)backgroundColor), ARGB.greenFloat((int)backgroundColor), ARGB.blueFloat((int)backgroundColor));
        float saturation = Math.min(1.0f, HSV.saturationFloat(hsv) * 1.2f);
        float value = Math.max(0.0f, HSV.valueFloat(hsv) * 0.75f);
        return Mth.hsvToRgb((float)HSV.hueFloat(hsv), (float)saturation, (float)value);
    }
}

