/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public final class CreativeModeTabHelper {
    static final Collection<Item> POTION_ITEMS = ImmutableSet.of((Object)Items.POTION, (Object)Items.SPLASH_POTION, (Object)Items.LINGERING_POTION, (Object)Items.TIPPED_ARROW);

    private CreativeModeTabHelper() {
    }

    public static Component getTitle(ResourceLocation resourceLocation) {
        String translationKey = "itemGroup.%s.%s".formatted(resourceLocation.getNamespace(), resourceLocation.getPath());
        return Component.translatable((String)translationKey);
    }

    public static CreativeModeTab.DisplayItemsGenerator getDisplayItems(String modId) {
        return (itemDisplayParameters, output) -> {
            CreativeModeTabHelper.generateItemTypes(modId, itemDisplayParameters, output);
            CreativeModeTabHelper.generateEnchantmentBookTypes(modId, itemDisplayParameters, output);
            CreativeModeTabHelper.generatePotionEffectTypes(modId, itemDisplayParameters, output);
            CreativeModeTabHelper.generatePaintingTypes(modId, itemDisplayParameters, output);
        };
    }

    public static void generateItemTypes(String modId, CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        itemDisplayParameters.holders().lookup(Registries.ITEM).ifPresent(registryLookup -> registryLookup.listElements().filter(holder -> holder.key().location().getNamespace().equals(modId)).map(ItemStack::new).forEach(itemStack -> output.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS)));
    }

    public static void generateEnchantmentBookTypes(String modId, CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        itemDisplayParameters.holders().lookup(Registries.ENCHANTMENT).ifPresent(registryLookup -> CreativeModeTabs.generateEnchantmentBookTypesOnlyMaxLevel((itemStack, tabVisibility) -> {
            if (((ItemEnchantments)itemStack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet().stream().findAny().flatMap(Holder::unwrapKey).map(ResourceKey::location).map(ResourceLocation::getNamespace).filter(modId::equals).isPresent()) {
                output.accept(itemStack, tabVisibility);
            }
        }, (HolderLookup)registryLookup, (CreativeModeTab.TabVisibility)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY));
    }

    public static void generatePotionEffectTypes(String modId, CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        itemDisplayParameters.holders().lookup(Registries.POTION).ifPresent(registryLookup -> {
            for (Item item : POTION_ITEMS) {
                CreativeModeTabs.generatePotionEffectTypes((itemStack, tabVisibility) -> {
                    if (((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().flatMap(Holder::unwrapKey).map(ResourceKey::location).map(ResourceLocation::getNamespace).filter(modId::equals).isPresent()) {
                        output.accept(itemStack, tabVisibility);
                    }
                }, (HolderLookup)registryLookup, (Item)item, (CreativeModeTab.TabVisibility)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, (FeatureFlagSet)itemDisplayParameters.enabledFeatures());
            }
        });
    }

    public static void generatePaintingTypes(String modId, CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        itemDisplayParameters.holders().lookup(Registries.PAINTING_VARIANT).ifPresent(registryLookup -> CreativeModeTabs.generatePresetPaintings((CreativeModeTab.Output)output, (HolderLookup.Provider)itemDisplayParameters.holders(), (HolderLookup.RegistryLookup)registryLookup, holder -> holder.unwrapKey().map(ResourceKey::location).map(ResourceLocation::getNamespace).filter(modId::equals).isPresent(), (CreativeModeTab.TabVisibility)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
    }
}

