/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.data.v2.core;

import com.google.common.base.Function;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.data.v2.core.RegistriesDataProvider;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.api.data.v2.core.NeoForgeDataProviderContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public final class DataProviderHelper {
    private DataProviderHelper() {
    }

    public static void registerDataProviders(String modId, NeoForgeDataProviderContext.Factory ... factories) {
        DataProviderHelper.registerDataProviders(modId, new RegistrySetBuilder(), factories);
    }

    public static void registerDataProviders(String modId, RegistrySetBuilder registrySetBuilder, NeoForgeDataProviderContext.Factory ... factories) {
        DataProviderHelper.registerDataProviders(modId, registrySetBuilder, factories, factory -> (evt, registries) -> (DataProvider)factory.apply(NeoForgeDataProviderContext.fromEvent(evt, registries)));
    }

    static <T> void registerDataProviders(String modId, RegistrySetBuilder registrySetBuilder, T[] factories, Function<T, Factory> factoryConverter) {
        if (!ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> eventBus.addListener(evt -> {
            if (!registrySetBuilder.getEntryKeys().isEmpty()) {
                evt.createDatapackRegistryObjects(registrySetBuilder);
            }
            CompletableFuture<HolderLookup.Provider> registries = evt.getLookupProvider();
            for (Object factory : factories) {
                DataProvider dataProvider = (DataProvider)((Factory)factoryConverter.apply(factory)).apply(evt, registries);
                if (dataProvider instanceof RegistriesDataProvider) {
                    RegistriesDataProvider registriesDataProvider = (RegistriesDataProvider)dataProvider;
                    registries = registriesDataProvider.getRegistries();
                }
                evt.addProvider(dataProvider);
            }
        }));
    }

    @FunctionalInterface
    static interface Factory
    extends BiFunction<GatherDataEvent, CompletableFuture<HolderLookup.Provider>, DataProvider> {
    }
}

