/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.event.v1.entity.living;

import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ComputeEnchantedLootBonusEvent
extends LivingEvent {
    @Nullable
    private final DamageSource damageSource;
    private final Holder<Enchantment> enchantment;
    private int enchantmentLevel;

    @ApiStatus.Internal
    public ComputeEnchantedLootBonusEvent(LivingEntity entity, @Nullable DamageSource damageSource, Holder<Enchantment> enchantment, int enchantmentLevel) {
        super(entity);
        this.damageSource = damageSource;
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
    }

    @Nullable
    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public Holder<Enchantment> getEnchantment() {
        return this.enchantment;
    }

    public int getEnchantmentLevel() {
        return this.enchantmentLevel;
    }

    public void setEnchantmentLevel(int enchantmentLevel) {
        this.enchantmentLevel = enchantmentLevel;
    }

    @ApiStatus.Internal
    public static int onComputeEnchantedLootBonus(Holder<Enchantment> enchantment, int enchantmentLevel, LootContext lootContext) {
        Entity entity = (Entity)lootContext.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (!(entity instanceof LivingEntity)) {
            return enchantmentLevel;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        DamageSource damageSource = (DamageSource)lootContext.getOptionalParameter(LootContextParams.DAMAGE_SOURCE);
        return ComputeEnchantedLootBonusEvent.onComputeEnchantedLootBonus(enchantment, enchantmentLevel, livingEntity, damageSource);
    }

    @ApiStatus.Internal
    public static int onComputeEnchantedLootBonus(Holder<Enchantment> enchantment, int enchantmentLevel, LivingEntity livingEntity, @Nullable DamageSource damageSource) {
        return ((ComputeEnchantedLootBonusEvent)NeoForge.EVENT_BUS.post((Event)new ComputeEnchantedLootBonusEvent(livingEntity, damageSource, enchantment, enchantmentLevel))).getEnchantmentLevel();
    }
}

