/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.core.context;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.neoforge.impl.event.NeoForgeEventInvokerRegistryImpl;
import fuzs.puzzleslib.neoforge.mixin.client.accessor.RegisterGuiLayersEventAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.GuiLayerManager;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public final class GuiLayersContextNeoForgeImpl
implements GuiLayersContext {
    private static final Map<ResourceLocation, ResourceLocation> VANILLA_GUI_LAYERS = ImmutableMap.builder().put((Object)CAMERA_OVERLAYS, (Object)VanillaGuiLayers.CAMERA_OVERLAYS).put((Object)CROSSHAIR, (Object)VanillaGuiLayers.CROSSHAIR).put((Object)HOTBAR, (Object)VanillaGuiLayers.HOTBAR).put((Object)JUMP_METER, (Object)VanillaGuiLayers.JUMP_METER).put((Object)EXPERIENCE_BAR, (Object)VanillaGuiLayers.EXPERIENCE_BAR).put((Object)PLAYER_HEALTH, (Object)VanillaGuiLayers.PLAYER_HEALTH).put((Object)ARMOR_LEVEL, (Object)VanillaGuiLayers.ARMOR_LEVEL).put((Object)FOOD_LEVEL, (Object)VanillaGuiLayers.FOOD_LEVEL).put((Object)VEHICLE_HEALTH, (Object)VanillaGuiLayers.VEHICLE_HEALTH).put((Object)AIR_LEVEL, (Object)VanillaGuiLayers.AIR_LEVEL).put((Object)SELECTED_ITEM_NAME, (Object)VanillaGuiLayers.SELECTED_ITEM_NAME).put((Object)EXPERIENCE_LEVEL, (Object)VanillaGuiLayers.EXPERIENCE_LEVEL).put((Object)STATUS_EFFECTS, (Object)VanillaGuiLayers.EFFECTS).put((Object)BOSS_BAR, (Object)VanillaGuiLayers.BOSS_OVERLAY).put((Object)SLEEP_OVERLAY, (Object)VanillaGuiLayers.SLEEP_OVERLAY).put((Object)DEMO_TIMER, (Object)VanillaGuiLayers.DEMO_OVERLAY).put((Object)DEBUG_OVERLAY, (Object)VanillaGuiLayers.DEBUG_OVERLAY).put((Object)SCOREBOARD, (Object)VanillaGuiLayers.SCOREBOARD_SIDEBAR).put((Object)OVERLAY_MESSAGE, (Object)VanillaGuiLayers.OVERLAY_MESSAGE).put((Object)TITLE, (Object)VanillaGuiLayers.TITLE).put((Object)CHAT, (Object)VanillaGuiLayers.CHAT).put((Object)PLAYER_LIST, (Object)VanillaGuiLayers.TAB_LIST).put((Object)SUBTITLES, (Object)VanillaGuiLayers.SUBTITLE_OVERLAY).build();
    private final IEventBus eventBus;
    private final Collection<Consumer<RegisterGuiLayersEvent>> eventConsumers = new ArrayList<Consumer<RegisterGuiLayersEvent>>();
    private EventPriority eventPriority = EventPriority.NORMAL;

    public GuiLayersContextNeoForgeImpl(IEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public void setEventPhase(EventPhase eventPhase) {
        Objects.requireNonNull(eventPhase, "event phase is null");
        if (!this.eventConsumers.isEmpty()) {
            throw new IllegalStateException("RegisterGuiLayersEvent already registered");
        }
        this.eventPriority = NeoForgeEventInvokerRegistryImpl.getEventPriorityFromPhase(eventPhase);
    }

    @Override
    public void registerGuiLayer(ResourceLocation resourceLocation, LayeredDraw.Layer guiLayer) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        Objects.requireNonNull(guiLayer, "gui layer is null");
        this.registerGuiLayer(evt -> evt.registerAboveAll(resourceLocation, guiLayer));
    }

    @Override
    public void registerGuiLayer(ResourceLocation resourceLocation, ResourceLocation otherResourceLocation, LayeredDraw.Layer guiLayer) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        Objects.requireNonNull(otherResourceLocation, "other resource location is null");
        Objects.requireNonNull(guiLayer, "gui layer is null");
        if (VANILLA_GUI_LAYERS.containsKey(resourceLocation)) {
            this.registerGuiLayer(evt -> evt.registerAbove(VANILLA_GUI_LAYERS.get(resourceLocation), otherResourceLocation, guiLayer));
        } else if (VANILLA_GUI_LAYERS.containsKey(otherResourceLocation)) {
            this.registerGuiLayer(evt -> evt.registerBelow(VANILLA_GUI_LAYERS.get(otherResourceLocation), resourceLocation, guiLayer));
        } else {
            throw new RuntimeException("Unregistered gui layers: " + String.valueOf(resourceLocation) + ", " + String.valueOf(otherResourceLocation));
        }
    }

    @Override
    public void replaceGuiLayer(ResourceLocation resourceLocation, UnaryOperator<LayeredDraw.Layer> guiLayerFactory) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        Objects.requireNonNull(guiLayerFactory, "gui layer factory is null");
        if (!VANILLA_GUI_LAYERS.containsKey(resourceLocation)) {
            throw new RuntimeException("Unregistered gui layer: " + String.valueOf(resourceLocation));
        }
        ResourceLocation vanillaResourceLocation = VANILLA_GUI_LAYERS.get(resourceLocation);
        this.registerGuiLayer(evt -> ((RegisterGuiLayersEventAccessor)evt).puzzleslib$getLayers().replaceAll(namedLayer -> {
            if (namedLayer.name().equals((Object)vanillaResourceLocation)) {
                return new GuiLayerManager.NamedLayer(namedLayer.name(), (guiGraphics, deltaTracker) -> {
                    if (namedLayer.name().equals((Object)VanillaGuiLayers.SLEEP_OVERLAY) || !Minecraft.getInstance().options.hideGui) {
                        ((LayeredDraw.Layer)guiLayerFactory.apply(namedLayer.layer())).render(guiGraphics, deltaTracker);
                    }
                });
            }
            return namedLayer;
        }));
    }

    private void registerGuiLayer(Consumer<RegisterGuiLayersEvent> eventConsumer) {
        if (this.eventConsumers.isEmpty()) {
            this.eventBus.addListener(this.eventPriority, evt -> {
                for (Consumer<RegisterGuiLayersEvent> consumer : this.eventConsumers) {
                    consumer.accept((RegisterGuiLayersEvent)evt);
                }
            });
        }
        this.eventConsumers.add(eventConsumer);
    }
}

