/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.event;

import com.mojang.blaze3d.shaders.FogShape;
import fuzs.puzzleslib.api.client.event.v1.AddResourcePackReloadListenersCallback;
import fuzs.puzzleslib.api.client.event.v1.ClientLifecycleEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientSetupCallback;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.InputEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.ClientEntityLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ClientPlayerCopyCallback;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ClientPlayerNetworkEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.entity.player.InteractionInputEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.MovementInputUpdateCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.AddToastCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ChatMessageReceivedCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ContainerScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.CustomizeChatPanelCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.GatherDebugTextEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.GatherEffectScreenTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.InventoryMobEffectsCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ItemTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderGuiEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderGuiLayerEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenKeyboardEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenOpeningCallback;
import fuzs.puzzleslib.api.client.event.v1.level.ClientChunkEvents;
import fuzs.puzzleslib.api.client.event.v1.level.ClientLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.level.ClientLevelTickEvents;
import fuzs.puzzleslib.api.client.event.v1.model.ModelBakingCompleteCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ComputeFieldOfViewCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ExtractRenderStateCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.FogEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.GameRenderEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderBlockOverlayCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHandEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHighlightCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderLivingEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderNameTagCallback;
import fuzs.puzzleslib.api.core.v1.resources.ForwardingReloadListenerHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableBoolean;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.impl.client.event.ScreenButtonList;
import fuzs.puzzleslib.neoforge.api.event.v1.core.NeoForgeEventInvokerRegistry;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.GatherEffectScreenTooltipsEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ToastAddEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.event.lifecycle.ClientStoppingEvent;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public final class NeoForgeClientEventInvokers {
    public static void registerLoadingHandlers() {
        NeoForgeEventInvokerRegistry.INSTANCE.register(AddResourcePackReloadListenersCallback.class, AddClientReloadListenersEvent.class, (callback, evt) -> callback.onAddResourcePackReloadListeners((resourceLocation, reloadListener) -> evt.addListener(resourceLocation, ForwardingReloadListenerHelper.fromReloadListener(resourceLocation, reloadListener))));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ScreenOpeningCallback.class, ScreenEvent.Opening.class, (callback, evt) -> {
            EventResultHolder<Screen> eventResult = callback.onScreenOpening(evt.getCurrentScreen(), evt.getNewScreen());
            eventResult.ifInterrupt(screen -> {
                if (screen == evt.getCurrentScreen()) {
                    evt.setCanceled(true);
                } else {
                    evt.setNewScreen(screen);
                }
            });
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ModelBakingCompleteCallback.class, ModelEvent.BakingCompleted.class, (callback, evt) -> callback.onModelBakingComplete(evt.getModelManager(), evt.getBakingResult()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ExtractRenderStateCallback.class, RegisterRenderStateModifiersEvent.class, (callback, evt) -> evt.registerEntityModifier(EntityRenderer.class, (entity, entityRenderState) -> callback.onExtractRenderState((Entity)entity, (EntityRenderState)entityRenderState, entityRenderState.partialTick)));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLifecycleEvents.Started.class, FMLLoadCompleteEvent.class, (callback, evt) -> evt.enqueueWork(() -> callback.onClientStarted(Minecraft.getInstance())));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLifecycleEvents.Stopping.class, ClientStoppingEvent.class, (callback, evt) -> callback.onClientStopping(evt.getClient()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientSetupCallback.class, FMLClientSetupEvent.class, (callback, evt) -> evt.enqueueWork(callback::onClientSetup));
    }

    public static void registerEventHandlers() {
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientTickEvents.Start.class, ClientTickEvent.Pre.class, (callback, evt) -> callback.onStartClientTick(Minecraft.getInstance()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientTickEvents.End.class, ClientTickEvent.Post.class, (callback, evt) -> callback.onEndClientTick(Minecraft.getInstance()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderGuiEvents.Before.class, RenderGuiEvent.Pre.class, (callback, evt) -> callback.onBeforeRenderGui(Minecraft.getInstance().gui, evt.getGuiGraphics(), evt.getPartialTick()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderGuiEvents.After.class, RenderGuiEvent.Post.class, (callback, evt) -> callback.onAfterRenderGui(Minecraft.getInstance().gui, evt.getGuiGraphics(), evt.getPartialTick()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ItemTooltipCallback.class, ItemTooltipEvent.class, (callback, evt) -> callback.onItemTooltip(evt.getItemStack(), evt.getToolTip(), evt.getContext(), evt.getEntity(), evt.getFlags()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderNameTagCallback.class, RenderNameTagEvent.DoRender.class, (callback, evt) -> {
            EventResult eventResult = callback.onRenderNameTag(evt.getEntityRenderState(), evt.getContent(), evt.getEntityRenderer(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ContainerScreenEvents.Background.class, ContainerScreenEvent.Render.Background.class, (callback, evt) -> callback.onDrawBackground(evt.getContainerScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ContainerScreenEvents.Foreground.class, ContainerScreenEvent.Render.Foreground.class, (callback, evt) -> callback.onDrawForeground(evt.getContainerScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(InventoryMobEffectsCallback.class, ScreenEvent.RenderInventoryMobEffects.class, (callback, evt) -> {
            MutableBoolean fullSizeRendering = MutableBoolean.fromEvent(arg_0 -> ((ScreenEvent.RenderInventoryMobEffects)evt).setCompact(arg_0), () -> ((ScreenEvent.RenderInventoryMobEffects)evt).isCompact());
            MutableInt horizontalOffset = MutableInt.fromEvent(arg_0 -> ((ScreenEvent.RenderInventoryMobEffects)evt).setHorizontalOffset(arg_0), () -> ((ScreenEvent.RenderInventoryMobEffects)evt).getHorizontalOffset());
            EventResult eventResult = callback.onInventoryMobEffects(evt.getScreen(), evt.getAvailableSpace(), fullSizeRendering, horizontalOffset);
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ComputeFovModifierCallback.class, ComputeFovModifierEvent.class, (callback, evt) -> {
            float fovEffectScale = ((Double)Minecraft.getInstance().options.fovEffectScale().get()).floatValue();
            if (fovEffectScale == 0.0f) {
                return;
            }
            Consumer<Float> consumer = value -> evt.setNewFovModifier(Mth.lerp((float)fovEffectScale, (float)1.0f, (float)value.floatValue()));
            Supplier<Float> supplier = () -> Float.valueOf((evt.getNewFovModifier() - 1.0f) / fovEffectScale + 1.0f);
            callback.onComputeFovModifier(evt.getPlayer(), DefaultedFloat.fromEvent(consumer, supplier, () -> ((ComputeFovModifierEvent)evt).getFovModifier()));
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.BeforeInit.class, ScreenEvent.Init.Pre.class, (callback, evt) -> callback.onBeforeInit(Minecraft.getInstance(), evt.getScreen(), evt.getScreen().width, evt.getScreen().height, new ScreenButtonList(evt.getScreen().renderables)));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.AfterInit.class, ScreenEvent.Init.Post.class, (callback, evt) -> callback.onAfterInit(Minecraft.getInstance(), evt.getScreen(), evt.getScreen().width, evt.getScreen().height, new ScreenButtonList(evt.getScreen().renderables), abstractWidget -> {
            evt.addListener((GuiEventListener)abstractWidget);
            return abstractWidget;
        }, arg_0 -> ((ScreenEvent.Init.Post)evt).removeListener(arg_0)));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.Remove.class, ScreenEvent.Closing.class, (callback, evt) -> callback.onRemove(evt.getScreen()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.BeforeRender.class, ScreenEvent.Render.Pre.class, (callback, evt) -> callback.onBeforeRender(evt.getScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.AfterRender.class, ScreenEvent.Render.Post.class, (callback, evt) -> callback.onAfterRender(evt.getScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseClick.class, ScreenEvent.MouseButtonPressed.Pre.class, (callback, evt) -> {
            EventResult eventResult = callback.onBeforeMouseClick(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseClick.class, ScreenEvent.MouseButtonPressed.Post.class, (callback, evt) -> callback.onAfterMouseClick(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseRelease.class, ScreenEvent.MouseButtonReleased.Pre.class, (callback, evt) -> {
            EventResult eventResult = callback.onBeforeMouseRelease(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseRelease.class, ScreenEvent.MouseButtonReleased.Post.class, (callback, evt) -> callback.onAfterMouseRelease(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseScroll.class, ScreenEvent.MouseScrolled.Pre.class, (callback, evt) -> {
            EventResult eventResult = callback.onBeforeMouseScroll(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getScrollDeltaX(), evt.getScrollDeltaY());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseScroll.class, ScreenEvent.MouseScrolled.Post.class, (callback, evt) -> callback.onAfterMouseScroll(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getScrollDeltaX(), evt.getScrollDeltaY()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseDrag.class, ScreenEvent.MouseDragged.Pre.class, (callback, evt) -> {
            EventResult eventResult = callback.onBeforeMouseDrag(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getMouseButton(), evt.getDragX(), evt.getDragY());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseDrag.class, ScreenEvent.MouseDragged.Post.class, (callback, evt) -> callback.onAfterMouseDrag(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getMouseButton(), evt.getDragX(), evt.getDragY()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyPress.class, ScreenEvent.KeyPressed.Pre.class, (callback, evt) -> {
            EventResult eventResult = callback.onBeforeKeyPress(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyPress.class, ScreenEvent.KeyPressed.Post.class, (callback, evt) -> callback.onAfterKeyPress(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyRelease.class, ScreenEvent.KeyReleased.Pre.class, (callback, evt) -> {
            EventResult eventResult = callback.onBeforeKeyRelease(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyRelease.class, ScreenEvent.KeyReleased.Post.class, (callback, evt) -> callback.onAfterKeyRelease(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderGuiLayerEvents.Before.class, RenderGuiLayerEvent.Pre.class, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            ResourceLocation resourceLocation = (ResourceLocation)context;
            if (!evt.getName().equals((Object)resourceLocation) || Minecraft.getInstance().options.hideGui) {
                return;
            }
            EventResult eventResult = callback.onBeforeRenderGuiLayer(Minecraft.getInstance().gui, evt.getGuiGraphics(), evt.getPartialTick());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderGuiLayerEvents.After.class, RenderGuiLayerEvent.Post.class, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            ResourceLocation resourceLocation = (ResourceLocation)context;
            if (!evt.getName().equals((Object)resourceLocation) || Minecraft.getInstance().options.hideGui) {
                return;
            }
            callback.onAfterRenderGuiLayer(Minecraft.getInstance().gui, evt.getGuiGraphics(), evt.getPartialTick());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(CustomizeChatPanelCallback.class, CustomizeGuiOverlayEvent.Chat.class, (callback, evt) -> {
            MutableInt posX = MutableInt.fromEvent(arg_0 -> ((CustomizeGuiOverlayEvent.Chat)evt).setPosX(arg_0), () -> ((CustomizeGuiOverlayEvent.Chat)evt).getPosX());
            MutableInt posY = MutableInt.fromEvent(arg_0 -> ((CustomizeGuiOverlayEvent.Chat)evt).setPosY(arg_0), () -> ((CustomizeGuiOverlayEvent.Chat)evt).getPosY());
            callback.onRenderChatPanel(evt.getGuiGraphics(), evt.getPartialTick(), posX, posY);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientEntityLevelEvents.Load.class, EntityJoinLevelEvent.class, (callback, evt) -> {
            Level patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            EventResult eventResult = callback.onEntityLoad(evt.getEntity(), clientLevel);
            if (eventResult.isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from spawning in!");
                }
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientEntityLevelEvents.Unload.class, EntityLeaveLevelEvent.class, (callback, evt) -> {
            Level patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onEntityUnload(evt.getEntity(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(InputEvents.MouseClick.class, InputEvent.MouseButton.Pre.class, (callback, evt) -> {
            EventResult eventResult = callback.onMouseClick(evt.getButton(), evt.getAction(), evt.getModifiers());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(InputEvents.MouseScroll.class, InputEvent.MouseScrollingEvent.class, (callback, evt) -> {
            EventResult eventResult = callback.onMouseScroll(evt.isLeftDown(), evt.isMiddleDown(), evt.isRightDown(), evt.getScrollDeltaX(), evt.getScrollDeltaY());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(InputEvents.KeyPress.class, InputEvent.Key.class, (callback, evt) -> callback.onKeyPress(evt.getKey(), evt.getScanCode(), evt.getAction(), evt.getModifiers()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ComputeCameraAnglesCallback.class, ViewportEvent.ComputeCameraAngles.class, (callback, evt) -> {
            MutableFloat pitch = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setPitch(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)evt).getPitch());
            MutableFloat yaw = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setYaw(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)evt).getYaw());
            MutableFloat roll = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setRoll(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)evt).getRoll());
            callback.onComputeCameraAngles(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTick(), pitch, yaw, roll);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderLivingEvents.Before.class, RenderLivingEvent.Pre.class, (callback, evt) -> {
            EventResult eventResult = callback.onBeforeRenderEntity(evt.getRenderState(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderLivingEvents.After.class, RenderLivingEvent.Post.class, (callback, evt) -> callback.onAfterRenderEntity(evt.getRenderState(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderHandEvents.MainHand.class, RenderHandEvent.class, (callback, evt) -> {
            if (evt.getHand() != InteractionHand.MAIN_HAND) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            ItemInHandRenderer itemInHandRenderer = minecraft.getEntityRenderDispatcher().getItemInHandRenderer();
            EventResult eventResult = callback.onRenderMainHand(itemInHandRenderer, evt.getHand(), (AbstractClientPlayer)minecraft.player, minecraft.player.getMainArm(), evt.getItemStack(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight(), evt.getPartialTick(), evt.getInterpolatedPitch(), evt.getSwingProgress(), evt.getEquipProgress());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderHandEvents.OffHand.class, RenderHandEvent.class, (callback, evt) -> {
            if (evt.getHand() != InteractionHand.OFF_HAND) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            ItemInHandRenderer itemInHandRenderer = minecraft.getEntityRenderDispatcher().getItemInHandRenderer();
            EventResult eventResult = callback.onRenderOffHand(itemInHandRenderer, evt.getHand(), (AbstractClientPlayer)minecraft.player, minecraft.player.getMainArm().getOpposite(), evt.getItemStack(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight(), evt.getPartialTick(), evt.getInterpolatedPitch(), evt.getSwingProgress(), evt.getEquipProgress());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLevelTickEvents.Start.class, LevelTickEvent.Pre.class, (callback, evt) -> {
            Level patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onStartLevelTick(Minecraft.getInstance(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLevelTickEvents.End.class, LevelTickEvent.Post.class, (callback, evt) -> {
            Level patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onEndLevelTick(Minecraft.getInstance(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientChunkEvents.Load.class, ChunkEvent.Load.class, (callback, evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onChunkLoad(clientLevel, (LevelChunk)evt.getChunk());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientChunkEvents.Unload.class, ChunkEvent.Unload.class, (callback, evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onChunkUnload(clientLevel, (LevelChunk)evt.getChunk());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientPlayerNetworkEvents.LoggedIn.class, ClientPlayerNetworkEvent.LoggingIn.class, (callback, evt) -> callback.onLoggedIn(evt.getPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientPlayerNetworkEvents.LoggedOut.class, ClientPlayerNetworkEvent.LoggingOut.class, (callback, evt) -> {
            if (evt.getPlayer() == null || evt.getMultiPlayerGameMode() == null) {
                return;
            }
            Objects.requireNonNull(evt.getConnection(), "connection is null");
            callback.onLoggedOut(evt.getPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientPlayerCopyCallback.class, ClientPlayerNetworkEvent.Clone.class, (callback, evt) -> callback.onCopy(evt.getOldPlayer(), evt.getNewPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.Attack.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, evt) -> {
            EventResult eventResult;
            if (!evt.isAttack()) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.hitResult != null && (eventResult = callback.onAttackInteraction(minecraft, minecraft.player, minecraft.hitResult)).isInterrupt()) {
                evt.setSwingHand(false);
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.Use.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, evt) -> {
            EventResult eventResult;
            if (!evt.isUseItem()) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.hitResult != null && minecraft.player.getItemInHand(evt.getHand()).isItemEnabled(minecraft.level.enabledFeatures()) && (minecraft.hitResult.getType() != HitResult.Type.ENTITY || minecraft.level.getWorldBorder().isWithinBounds(((EntityHitResult)minecraft.hitResult).getEntity().blockPosition())) && (eventResult = callback.onUseInteraction(minecraft, minecraft.player, evt.getHand(), minecraft.hitResult)).isInterrupt()) {
                evt.setSwingHand(false);
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.Pick.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, evt) -> {
            if (!evt.isPickBlock()) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            EventResult eventResult = callback.onPickInteraction(minecraft, minecraft.player, minecraft.hitResult);
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLevelEvents.Load.class, LevelEvent.Load.class, (callback, evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onLevelLoad(Minecraft.getInstance(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLevelEvents.Unload.class, LevelEvent.Unload.class, (callback, evt) -> {
            LevelAccessor patt0$temp = evt.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onLevelUnload(Minecraft.getInstance(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(MovementInputUpdateCallback.class, MovementInputUpdateEvent.class, (callback, evt) -> callback.onMovementInputUpdate((LocalPlayer)evt.getEntity(), evt.getInput()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderBlockOverlayCallback.class, RenderBlockScreenEffectEvent.class, (callback, evt) -> {
            EventResult eventResult = callback.onRenderBlockOverlay((LocalPlayer)evt.getPlayer(), evt.getPoseStack(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), evt.getBlockState());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(FogEvents.Render.class, ViewportEvent.RenderFog.class, (callback, evt) -> {
            MutableFloat nearPlaneDistance = MutableFloat.fromEvent(nearPlaneDistanceValue -> {
                evt.setNearPlaneDistance(nearPlaneDistanceValue.floatValue());
                evt.setCanceled(true);
            }, () -> ((ViewportEvent.RenderFog)evt).getNearPlaneDistance());
            MutableFloat farPlaneDistance = MutableFloat.fromEvent(farPlaneDistanceValue -> {
                evt.setFarPlaneDistance(farPlaneDistanceValue.floatValue());
                evt.setCanceled(true);
            }, () -> ((ViewportEvent.RenderFog)evt).getFarPlaneDistance());
            MutableValue<FogShape> fogShape = MutableValue.fromEvent(fogShapeValue -> {
                evt.setFogShape(fogShapeValue);
                evt.setCanceled(true);
            }, () -> ((ViewportEvent.RenderFog)evt).getFogShape());
            callback.onRenderFog(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTick(), evt.getMode(), evt.getType(), nearPlaneDistance, farPlaneDistance, fogShape);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(FogEvents.ComputeColor.class, ViewportEvent.ComputeFogColor.class, (callback, evt) -> {
            MutableFloat red = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFogColor)evt).setRed(arg_0), () -> ((ViewportEvent.ComputeFogColor)evt).getRed());
            MutableFloat green = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFogColor)evt).setGreen(arg_0), () -> ((ViewportEvent.ComputeFogColor)evt).getGreen());
            MutableFloat blue = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFogColor)evt).setBlue(arg_0), () -> ((ViewportEvent.ComputeFogColor)evt).getBlue());
            callback.onComputeFogColor(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTick(), red, green, blue);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderTooltipCallback.class, RenderTooltipEvent.Pre.class, (callback, evt) -> {
            EventResult eventResult = callback.onRenderTooltip(evt.getGraphics(), evt.getFont(), evt.getX(), evt.getY(), evt.getComponents(), evt.getTooltipPositioner());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderHighlightCallback.class, RenderHighlightEvent.Block.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.getInstance();
            if (!(minecraft.getCameraEntity() instanceof Player) || minecraft.options.hideGui) {
                return;
            }
            EventResult eventResult = callback.onRenderHighlight(evt.getLevelRenderer(), evt.getCamera(), minecraft.gameRenderer, (HitResult)evt.getTarget(), evt.getDeltaTracker(), evt.getPoseStack(), evt.getMultiBufferSource(), minecraft.level);
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        }, true);
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderHighlightCallback.class, RenderHighlightEvent.Entity.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.getInstance();
            if (!(minecraft.getCameraEntity() instanceof Player) || minecraft.options.hideGui) {
                return;
            }
            callback.onRenderHighlight(evt.getLevelRenderer(), evt.getCamera(), minecraft.gameRenderer, (HitResult)evt.getTarget(), evt.getDeltaTracker(), evt.getPoseStack(), evt.getMultiBufferSource(), minecraft.level);
        }, true);
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderLevelEvents.AfterTerrain.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            callback.onRenderLevelAfterTerrain(evt.getLevelRenderer(), evt.getCamera(), minecraft.gameRenderer, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.level);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderLevelEvents.AfterEntities.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            callback.onRenderLevelAfterEntities(evt.getLevelRenderer(), evt.getCamera(), minecraft.gameRenderer, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.level);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderLevelEvents.AfterTranslucent.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            callback.onRenderLevelAfterTranslucent(evt.getLevelRenderer(), evt.getCamera(), minecraft.gameRenderer, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.level);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderLevelEvents.AfterLevel.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            callback.onRenderLevelAfterLevel(evt.getLevelRenderer(), evt.getCamera(), minecraft.gameRenderer, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.level);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(GameRenderEvents.Before.class, RenderFrameEvent.Pre.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.getInstance();
            callback.onBeforeGameRender(minecraft, minecraft.gameRenderer, evt.getPartialTick());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(GameRenderEvents.After.class, RenderFrameEvent.Post.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.getInstance();
            callback.onAfterGameRender(minecraft, minecraft.gameRenderer, evt.getPartialTick());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(AddToastCallback.class, ToastAddEvent.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.getInstance();
            EventResult eventResult = callback.onAddToast(minecraft.getToastManager(), evt.getToast());
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(GatherDebugTextEvents.Left.class, CustomizeGuiOverlayEvent.DebugText.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.getInstance();
            if (!minecraft.getDebugOverlay().showDebugScreen()) {
                return;
            }
            callback.onGatherLeftDebugText(evt.getWindow(), evt.getGuiGraphics(), evt.getPartialTick(), evt.getLeft());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(GatherDebugTextEvents.Right.class, CustomizeGuiOverlayEvent.DebugText.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.getInstance();
            if (!minecraft.getDebugOverlay().showDebugScreen()) {
                return;
            }
            callback.onGatherRightDebugText(evt.getWindow(), evt.getGuiGraphics(), evt.getPartialTick(), evt.getRight());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ComputeFieldOfViewCallback.class, ViewportEvent.ComputeFov.class, (callback, evt) -> {
            MutableFloat fieldOfView = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFov)evt).setFOV(arg_0), () -> ((ViewportEvent.ComputeFov)evt).getFOV());
            callback.onComputeFieldOfView(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTick(), fieldOfView);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ChatMessageReceivedCallback.class, ClientChatReceivedEvent.class, (callback, evt) -> {
            ClientChatReceivedEvent.System system;
            PlayerChatMessage playerChatMessage;
            MutableValue<Component> message = MutableValue.fromEvent(arg_0 -> ((ClientChatReceivedEvent)evt).setMessage(arg_0), () -> ((ClientChatReceivedEvent)evt).getMessage());
            if (evt instanceof ClientChatReceivedEvent.Player) {
                ClientChatReceivedEvent.Player player = (ClientChatReceivedEvent.Player)evt;
                playerChatMessage = player.getPlayerChatMessage();
            } else {
                playerChatMessage = null;
            }
            PlayerChatMessage playerChatMessage2 = playerChatMessage;
            boolean isOverlay = evt instanceof ClientChatReceivedEvent.System && (system = (ClientChatReceivedEvent.System)evt).isOverlay();
            EventResult eventResult = callback.onChatMessageReceived(message, evt.getBoundChatType(), playerChatMessage2, isOverlay);
            if (eventResult.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(GatherEffectScreenTooltipCallback.class, GatherEffectScreenTooltipsEvent.class, (callback, evt) -> callback.onGatherEffectScreenTooltip(evt.getScreen(), evt.getEffectInstance(), evt.getTooltip()));
    }

    private static <T, E extends ScreenEvent> void registerScreenEvent(Class<T> clazz, Class<E> event, BiConsumer<T, E> converter) {
        NeoForgeEventInvokerRegistry.INSTANCE.register(clazz, event, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            if (!((Class)context).isInstance(evt.getScreen())) {
                return;
            }
            converter.accept(callback, evt);
        });
    }
}

