/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core;

import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.impl.core.context.ModConstructorImpl;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.impl.core.NeoForgeProxy;
import fuzs.puzzleslib.neoforge.impl.core.context.AbstractNeoForgeContext;
import fuzs.puzzleslib.neoforge.impl.core.context.BiomeModificationsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.DataPackRegistriesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.DataPackSourcesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.EntityAttributesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.GameRegistriesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.GameplayContentContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.SpawnPlacementsContextNeoForgeImpl;
import net.minecraft.server.packs.PackType;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;

public final class NeoForgeModConstructor
implements ModConstructorImpl<ModConstructor> {
    @Override
    public void construct(String modId, ModConstructor modConstructor) {
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> {
            EntityAttributesContextNeoForgeImpl[] entityAttributesContext = new EntityAttributesContextNeoForgeImpl[1];
            modConstructor.onConstructMod();
            modConstructor.onRegisterGameplayContent(new GameplayContentContextNeoForgeImpl(modId, (IEventBus)eventBus));
            modConstructor.onRegisterBiomeModifications(new BiomeModificationsContextNeoForgeImpl(modId, (IEventBus)eventBus));
            eventBus.addListener(evt -> evt.enqueueWork(modConstructor::onCommonSetup));
            eventBus.addListener(evt -> modConstructor.onRegisterPayloadTypes(NeoForgeProxy.get().createPayloadTypesContext(modId, (RegisterPayloadHandlersEvent)evt)));
            eventBus.addListener(evt -> modConstructor.onRegisterSpawnPlacements(new SpawnPlacementsContextNeoForgeImpl((RegisterSpawnPlacementsEvent)evt)));
            eventBus.addListener(evt -> AbstractNeoForgeContext.computeIfAbsent(entityAttributesContext, EntityAttributesContextNeoForgeImpl::new, modConstructor::onRegisterEntityAttributes).registerForEvent((Event)evt));
            eventBus.addListener(evt -> AbstractNeoForgeContext.computeIfAbsent(entityAttributesContext, EntityAttributesContextNeoForgeImpl::new, modConstructor::onRegisterEntityAttributes).registerForEvent((Event)evt));
            eventBus.addListener(evt -> {
                if (evt.getPackType() == PackType.SERVER_DATA) {
                    modConstructor.onAddDataPackFinders(new DataPackSourcesContextNeoForgeImpl((AddPackFindersEvent)evt));
                }
            });
            eventBus.addListener(evt -> modConstructor.onRegisterGameRegistriesContext(new GameRegistriesContextNeoForgeImpl((NewRegistryEvent)evt)));
            eventBus.addListener(evt -> modConstructor.onRegisterDataPackRegistriesContext(new DataPackRegistriesContextNeoForgeImpl((DataPackRegistryEvent.NewRegistry)evt)));
        });
    }
}

