/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import fuzs.puzzleslib.impl.container.SlotsProvider;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public final class ContainerSerializationHelper {
    private ContainerSerializationHelper() {
    }

    public static void saveAllItems(ValueOutput valueOutput, NonNullList<ItemStack> itemStacks) {
        ContainerSerializationHelper.storeAsSlots(itemStacks, (ValueOutput.TypedOutputList<ItemStackWithSlot>)valueOutput.list("Items", ItemStackWithSlot.CODEC));
    }

    public static void saveAllItems(ValueOutput valueOutput, Container container) {
        ContainerSerializationHelper.storeAsSlots(container, (ValueOutput.TypedOutputList<ItemStackWithSlot>)valueOutput.list("Items", ItemStackWithSlot.CODEC));
    }

    public static void storeAsSlots(NonNullList<ItemStack> itemStacks, ValueOutput.TypedOutputList<ItemStackWithSlot> typedOutputList) {
        ContainerSerializationHelper.storeAsSlots(SlotsProvider.of(itemStacks), typedOutputList);
    }

    public static void storeAsSlots(Container container, ValueOutput.TypedOutputList<ItemStackWithSlot> typedOutputList) {
        ContainerSerializationHelper.storeAsSlots(SlotsProvider.of(container), typedOutputList);
    }

    private static void storeAsSlots(SlotsProvider slotsProvider, ValueOutput.TypedOutputList<ItemStackWithSlot> typedOutputList) {
        for (int i = 0; i < slotsProvider.getContainerSize(); ++i) {
            ItemStack itemStack = slotsProvider.getItem(i);
            if (itemStack.isEmpty()) continue;
            typedOutputList.add((Object)new ItemStackWithSlot(i, itemStack));
        }
    }

    public static void loadAllItems(ValueInput valueInput, NonNullList<ItemStack> itemStacks) {
        ContainerSerializationHelper.fromSlots(itemStacks, (ValueInput.TypedInputList<ItemStackWithSlot>)valueInput.listOrEmpty("Items", ItemStackWithSlot.CODEC));
    }

    public static void loadAllItems(ValueInput valueInput, Container container) {
        ContainerSerializationHelper.fromSlots(container, (ValueInput.TypedInputList<ItemStackWithSlot>)valueInput.listOrEmpty("Items", ItemStackWithSlot.CODEC));
    }

    public static void fromSlots(NonNullList<ItemStack> itemStacks, ValueInput.TypedInputList<ItemStackWithSlot> typedInputList) {
        ContainerSerializationHelper.fromSlots(SlotsProvider.of(itemStacks), typedInputList);
    }

    public static void fromSlots(Container container, ValueInput.TypedInputList<ItemStackWithSlot> typedInputList) {
        ContainerSerializationHelper.fromSlots(SlotsProvider.of(container), typedInputList);
    }

    private static void fromSlots(SlotsProvider slotsProvider, ValueInput.TypedInputList<ItemStackWithSlot> typedInputList) {
        slotsProvider.clearContent();
        for (ItemStackWithSlot itemStackWithSlot : typedInputList) {
            if (!itemStackWithSlot.isValidInContainer(slotsProvider.getContainerSize())) continue;
            slotsProvider.setItem(itemStackWithSlot.slot(), itemStackWithSlot.stack());
        }
    }
}

