/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import fuzs.puzzleslib.impl.config.ConfigHolderImpl;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import fuzs.puzzleslib.impl.init.RegistryManagerImpl;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public abstract class ModContext {
    private static final Map<String, ModContext> MOD_CONTEXTS = new ConcurrentHashMap<String, ModContext>();
    private final String modId;
    protected final CustomPacketPayload.Type<BrandPayload> payloadType;
    @Nullable
    private ConfigHolderImpl configHolder;
    @Nullable
    private RegistryManagerImpl registryManager;

    public ModContext(String modId) {
        this.modId = modId;
        this.payloadType = new CustomPacketPayload.Type(ResourceLocationHelper.fromNamespaceAndPath(modId, "handshake"));
    }

    public static void forEach(Consumer<ModContext> modContextConsumer) {
        MOD_CONTEXTS.values().forEach(modContextConsumer);
    }

    public static Map<String, ModContext> getModContexts() {
        return Collections.unmodifiableMap(MOD_CONTEXTS);
    }

    public static ModContext get(String modId) {
        return MOD_CONTEXTS.computeIfAbsent(modId, ProxyImpl.get()::getModContext);
    }

    public abstract boolean isPresentServerside();

    public abstract boolean isPresentClientside(ServerPlayer var1);

    public final ConfigHolder.Builder getConfigHolder() {
        if (this.configHolder == null) {
            this.configHolder = this.createConfigHolder(this.modId);
            return this.configHolder;
        }
        return this.configHolder;
    }

    protected abstract ConfigHolderImpl createConfigHolder(String var1);

    public final RegistryManager getRegistryManager() {
        if (this.registryManager == null) {
            this.registryManager = this.createRegistryManager(this.modId);
            return this.registryManager;
        }
        return this.registryManager;
    }

    protected abstract RegistryManagerImpl createRegistryManager(String var1);

    public void runBeforeConstruction() {
        if (this.configHolder != null) {
            this.configHolder.freeze();
        }
    }

    public void runAfterConstruction() {
        if (this.registryManager != null) {
            this.registryManager.freeze();
            this.registryManager.isFrozenOrThrow();
        }
        if (this.configHolder != null) {
            this.configHolder.isFrozenOrThrow();
        }
    }
}

