/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.event;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.puzzleslib.api.client.event.v1.AddResourcePackReloadListenersCallback;
import fuzs.puzzleslib.api.client.event.v1.ClientInputEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientLifecycleEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientSetupCallback;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.ClientEntityLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ClientPlayerCopyCallback;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ClientPlayerNetworkEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.entity.player.InteractionInputEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.MovementInputUpdateCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.AddToastCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ChatMessageReceivedCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.CustomizeChatPanelCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.DrawItemStackOverlayCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.GatherEffectScreenTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ItemTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.PrepareInventoryMobEffectsCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderContainerScreenContentsCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderGuiEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenKeyboardEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenOpeningCallback;
import fuzs.puzzleslib.api.client.event.v1.level.ClientChunkEvents;
import fuzs.puzzleslib.api.client.event.v1.level.ClientLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.level.ClientLevelTickEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.AddLivingEntityRenderLayersCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ComputeFieldOfViewCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ExtractRenderStateCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.FogEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.GameRenderEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderBlockOverlayCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHandEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderLivingEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderNameTagCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.SubmitBlockOutlineCallback;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.MutableBoolean;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.impl.client.event.ScreenButtonList;
import fuzs.puzzleslib.impl.event.data.DefaultedFloat;
import fuzs.puzzleslib.neoforge.api.event.v1.core.NeoForgeEventInvokerRegistry;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ExtractBlockOutlineRenderStateEvent;
import net.neoforged.neoforge.client.event.GatherEffectScreenTooltipsEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ToastAddEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.event.lifecycle.ClientStartedEvent;
import net.neoforged.neoforge.client.event.lifecycle.ClientStoppingEvent;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeClientEventInvokers {
    public static void registerLoadingHandlers() {
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientSetupCallback.class, FMLClientSetupEvent.class, (callback, event) -> event.enqueueWork(callback::onClientSetup));
        NeoForgeEventInvokerRegistry.INSTANCE.register(AddResourcePackReloadListenersCallback.class, AddClientReloadListenersEvent.class, (callback, event) -> callback.onAddResourcePackReloadListeners((arg_0, arg_1) -> ((AddClientReloadListenersEvent)event).addListener(arg_0, arg_1)));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ScreenOpeningCallback.class, ScreenEvent.Opening.class, (callback, event) -> {
            EventResultHolder<Screen> eventResult = callback.onScreenOpening(event.getCurrentScreen(), event.getNewScreen());
            eventResult.ifInterrupt(screen -> {
                if (screen == event.getCurrentScreen()) {
                    event.setCanceled(true);
                } else {
                    event.setNewScreen(screen);
                }
            });
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ExtractRenderStateCallback.class, RegisterRenderStateModifiersEvent.class, (callback, event) -> event.registerEntityModifier(EntityRenderer.class, (entity, entityRenderState) -> callback.onExtractRenderState((Entity)entity, (EntityRenderState)entityRenderState, entityRenderState.partialTick)));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLifecycleEvents.Started.class, ClientStartedEvent.class, (callback, event) -> callback.onClientStarted(Minecraft.getInstance()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLifecycleEvents.Stopping.class, ClientStoppingEvent.class, (callback, event) -> callback.onClientStopping(event.getClient()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(DrawItemStackOverlayCallback.class, RegisterItemDecorationsEvent.class, (callback, event, context) -> {
            Objects.requireNonNull(context, "context is null");
            Item item = (Item)context;
            event.register((ItemLike)item, (guiGraphics, font, itemStack, posX, posY) -> {
                callback.onDrawItemStackOverlay(guiGraphics, font, itemStack, posX, posY);
                return false;
            });
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(AddLivingEntityRenderLayersCallback.class, EntityRenderersEvent.AddLayers.class, (callback, event) -> {
            for (PlayerModelType playerModelType : PlayerModelType.values()) {
                AvatarRenderer avatarRenderer = event.getPlayerRenderer(playerModelType);
                if (avatarRenderer != null) {
                    callback.addLivingEntityRenderLayers((EntityType<?>)EntityType.PLAYER, (LivingEntityRenderer<?, ?, ?>)avatarRenderer, event.getContext());
                }
                if ((avatarRenderer = event.getMannequinRenderer(playerModelType)) == null) continue;
                callback.addLivingEntityRenderLayers((EntityType<?>)EntityType.MANNEQUIN, (LivingEntityRenderer<?, ?, ?>)avatarRenderer, event.getContext());
            }
            for (EntityType entityType : event.getEntityTypes()) {
                EntityRenderer patt0$temp = event.getRenderer(entityType);
                if (!(patt0$temp instanceof LivingEntityRenderer)) continue;
                LivingEntityRenderer entityRenderer = (LivingEntityRenderer)patt0$temp;
                callback.addLivingEntityRenderLayers(entityType, entityRenderer, event.getContext());
            }
        });
    }

    public static void registerEventHandlers() {
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientTickEvents.Start.class, ClientTickEvent.Pre.class, (callback, event) -> callback.onStartClientTick(Minecraft.getInstance()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientTickEvents.End.class, ClientTickEvent.Post.class, (callback, event) -> callback.onEndClientTick(Minecraft.getInstance()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderGuiEvents.Before.class, RenderGuiEvent.Pre.class, (callback, event) -> callback.onBeforeRenderGui(event.getGuiGraphics(), event.getPartialTick()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderGuiEvents.After.class, RenderGuiEvent.Post.class, (callback, event) -> callback.onAfterRenderGui(event.getGuiGraphics(), event.getPartialTick()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ItemTooltipCallback.class, ItemTooltipEvent.class, (callback, event) -> {
            if (!RenderSystem.isOnRenderThread()) {
                return;
            }
            callback.onItemTooltip(event.getItemStack(), event.getToolTip(), event.getContext(), event.getEntity(), event.getFlags());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderNameTagCallback.class, RenderNameTagEvent.DoRender.class, (callback, event) -> {
            EventResult eventResult = callback.onRenderNameTag(event.getEntityRenderer(), event.getEntityRenderState(), event.getPoseStack(), event.getSubmitNodeCollector(), event.getCameraRenderState());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(PrepareInventoryMobEffectsCallback.class, ScreenEvent.RenderInventoryMobEffects.class, (callback, event) -> {
            MutableBoolean fullSizeRendering = MutableBoolean.fromEvent(arg_0 -> ((ScreenEvent.RenderInventoryMobEffects)event).setCompact(arg_0), () -> ((ScreenEvent.RenderInventoryMobEffects)event).isCompact());
            MutableInt horizontalOffset = MutableInt.fromEvent(arg_0 -> ((ScreenEvent.RenderInventoryMobEffects)event).setHorizontalOffset(arg_0), () -> ((ScreenEvent.RenderInventoryMobEffects)event).getHorizontalOffset());
            EventResult eventResult = callback.onPrepareInventoryMobEffects(event.getScreen(), event.getAvailableSpace(), fullSizeRendering, horizontalOffset);
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ComputeFovModifierCallback.class, ComputeFovModifierEvent.class, (callback, event) -> {
            float fovEffectScale = ((Double)Minecraft.getInstance().options.fovEffectScale().get()).floatValue();
            if (fovEffectScale == 0.0f) {
                return;
            }
            Consumer<Float> consumer = value -> event.setNewFovModifier(Mth.lerp((float)fovEffectScale, (float)1.0f, (float)value.floatValue()));
            Supplier<Float> supplier = () -> Float.valueOf((event.getNewFovModifier() - 1.0f) / fovEffectScale + 1.0f);
            callback.onComputeFovModifier(event.getPlayer(), DefaultedFloat.fromEvent(consumer, supplier, () -> ((ComputeFovModifierEvent)event).getFovModifier()));
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.BeforeInit.class, ScreenEvent.Init.Pre.class, (callback, event) -> callback.onBeforeInit(Minecraft.getInstance(), event.getScreen(), event.getScreen().width, event.getScreen().height, new ScreenButtonList(event.getScreen().renderables)));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.AfterInit.class, ScreenEvent.Init.Post.class, (callback, event) -> callback.onAfterInit(Minecraft.getInstance(), event.getScreen(), event.getScreen().width, event.getScreen().height, new ScreenButtonList(event.getScreen().renderables), abstractWidget -> {
            event.addListener((GuiEventListener)abstractWidget);
            return abstractWidget;
        }, arg_0 -> ((ScreenEvent.Init.Post)event).removeListener(arg_0)));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.Remove.class, ScreenEvent.Closing.class, (callback, event) -> callback.onRemove(event.getScreen()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.BeforeRender.class, ScreenEvent.Render.Pre.class, (callback, event) -> callback.onBeforeRender(event.getScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.AfterBackground.class, ScreenEvent.Render.Background.class, (callback, event) -> callback.onAfterBackground(event.getScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenEvents.AfterRender.class, ScreenEvent.Render.Post.class, (callback, event) -> callback.onAfterRender(event.getScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseClick.class, ScreenEvent.MouseButtonPressed.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onBeforeMouseClick(event.getScreen(), event.getMouseButtonEvent());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseClick.class, ScreenEvent.MouseButtonPressed.Post.class, (callback, event) -> callback.onAfterMouseClick(event.getScreen(), event.getMouseButtonEvent()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseRelease.class, ScreenEvent.MouseButtonReleased.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onBeforeMouseRelease(event.getScreen(), event.getMouseButtonEvent());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseRelease.class, ScreenEvent.MouseButtonReleased.Post.class, (callback, event) -> callback.onAfterMouseRelease(event.getScreen(), event.getMouseButtonEvent()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseScroll.class, ScreenEvent.MouseScrolled.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onBeforeMouseScroll(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getScrollDeltaX(), event.getScrollDeltaY());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseScroll.class, ScreenEvent.MouseScrolled.Post.class, (callback, event) -> callback.onAfterMouseScroll(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getScrollDeltaX(), event.getScrollDeltaY()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseDrag.class, ScreenEvent.MouseDragged.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onBeforeMouseDrag(event.getScreen(), event.getMouseButtonEvent(), event.getDragX(), event.getDragY());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseDrag.class, ScreenEvent.MouseDragged.Post.class, (callback, event) -> callback.onAfterMouseDrag(event.getScreen(), event.getMouseButtonEvent(), event.getDragX(), event.getDragY()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyPress.class, ScreenEvent.KeyPressed.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onBeforeKeyPress(event.getScreen(), event.getKeyEvent());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyPress.class, ScreenEvent.KeyPressed.Post.class, (callback, event) -> callback.onAfterKeyPress(event.getScreen(), event.getKeyEvent()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyRelease.class, ScreenEvent.KeyReleased.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onBeforeKeyRelease(event.getScreen(), event.getKeyEvent());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyRelease.class, ScreenEvent.KeyReleased.Post.class, (callback, event) -> callback.onAfterKeyRelease(event.getScreen(), event.getKeyEvent()));
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeCharacterType.class, ScreenEvent.CharacterTyped.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onBeforeCharacterType(event.getScreen(), event.getCharacterEvent());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterCharacterType.class, ScreenEvent.CharacterTyped.Post.class, (callback, event) -> callback.onAfterCharacterType(event.getScreen(), event.getCharacterEvent()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderContainerScreenContentsCallback.class, ContainerScreenEvent.Render.Foreground.class, (callback, event) -> callback.onRenderContainerScreenContents(event.getContainerScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(CustomizeChatPanelCallback.class, CustomizeGuiOverlayEvent.Chat.class, (callback, event) -> {
            MutableInt posX = MutableInt.fromEvent(arg_0 -> ((CustomizeGuiOverlayEvent.Chat)event).setPosX(arg_0), () -> ((CustomizeGuiOverlayEvent.Chat)event).getPosX());
            MutableInt posY = MutableInt.fromEvent(arg_0 -> ((CustomizeGuiOverlayEvent.Chat)event).setPosY(arg_0), () -> ((CustomizeGuiOverlayEvent.Chat)event).getPosY());
            callback.onRenderChatPanel(event.getGuiGraphics(), event.getPartialTick(), posX, posY);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientEntityLevelEvents.Load.class, EntityJoinLevelEvent.class, (callback, event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            EventResult eventResult = callback.onEntityLoad(event.getEntity(), clientLevel);
            if (eventResult.isInterrupt()) {
                if (event.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from spawning in!");
                }
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientEntityLevelEvents.Unload.class, EntityLeaveLevelEvent.class, (callback, event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onEntityUnload(event.getEntity(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientInputEvents.MouseClick.class, InputEvent.MouseButton.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onMouseClick(event.getMouseButtonInfo(), event.getAction());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientInputEvents.MouseScroll.class, InputEvent.MouseScrollingEvent.class, (callback, event) -> {
            EventResult eventResult = callback.onMouseScroll(event.isLeftDown(), event.isMiddleDown(), event.isRightDown(), event.getScrollDeltaX(), event.getScrollDeltaY());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientInputEvents.KeyPress.class, InputEvent.Key.class, (callback, event) -> callback.onKeyPress(event.getKeyEvent(), event.getAction()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ComputeCameraAnglesCallback.class, ViewportEvent.ComputeCameraAngles.class, (callback, event) -> {
            MutableFloat pitch = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)event).setPitch(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)event).getPitch());
            MutableFloat yaw = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)event).setYaw(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)event).getYaw());
            MutableFloat roll = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)event).setRoll(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)event).getRoll());
            callback.onComputeCameraAngles(event.getRenderer(), event.getCamera(), (float)event.getPartialTick(), pitch, yaw, roll);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderLivingEvents.Before.class, RenderLivingEvent.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onBeforeRenderEntity(event.getRenderState(), event.getRenderer(), event.getPartialTick(), event.getPoseStack(), event.getSubmitNodeCollector());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderLivingEvents.After.class, RenderLivingEvent.Post.class, (callback, event) -> callback.onAfterRenderEntity(event.getRenderState(), event.getRenderer(), event.getPartialTick(), event.getPoseStack(), event.getSubmitNodeCollector()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderHandEvents.MainHand.class, RenderHandEvent.class, (callback, event) -> {
            if (event.getHand() != InteractionHand.MAIN_HAND) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            ItemInHandRenderer itemInHandRenderer = minecraft.getEntityRenderDispatcher().getItemInHandRenderer();
            EventResult eventResult = callback.onRenderMainHand(itemInHandRenderer, event.getHand(), (AbstractClientPlayer)minecraft.player, minecraft.player.getMainArm(), event.getItemStack(), event.getPoseStack(), event.getSubmitNodeCollector(), event.getPackedLight(), event.getPartialTick(), event.getInterpolatedPitch(), event.getSwingProgress(), event.getEquipProgress());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderHandEvents.OffHand.class, RenderHandEvent.class, (callback, event) -> {
            if (event.getHand() != InteractionHand.OFF_HAND) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            ItemInHandRenderer itemInHandRenderer = minecraft.getEntityRenderDispatcher().getItemInHandRenderer();
            EventResult eventResult = callback.onRenderOffHand(itemInHandRenderer, event.getHand(), (AbstractClientPlayer)minecraft.player, minecraft.player.getMainArm().getOpposite(), event.getItemStack(), event.getPoseStack(), event.getSubmitNodeCollector(), event.getPackedLight(), event.getPartialTick(), event.getInterpolatedPitch(), event.getSwingProgress(), event.getEquipProgress());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLevelTickEvents.Start.class, LevelTickEvent.Pre.class, (callback, event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onStartLevelTick(Minecraft.getInstance(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLevelTickEvents.End.class, LevelTickEvent.Post.class, (callback, event) -> {
            Level patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onEndLevelTick(Minecraft.getInstance(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientChunkEvents.Load.class, ChunkEvent.Load.class, (callback, event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onChunkLoad(clientLevel, (LevelChunk)event.getChunk());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientChunkEvents.Unload.class, ChunkEvent.Unload.class, (callback, event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onChunkUnload(clientLevel, (LevelChunk)event.getChunk());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientPlayerNetworkEvents.LoggedIn.class, ClientPlayerNetworkEvent.LoggingIn.class, (callback, event) -> callback.onLoggedIn(event.getPlayer(), event.getMultiPlayerGameMode(), event.getConnection()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientPlayerNetworkEvents.LoggedOut.class, ClientPlayerNetworkEvent.LoggingOut.class, (callback, event) -> {
            if (event.getPlayer() == null || event.getMultiPlayerGameMode() == null) {
                return;
            }
            Objects.requireNonNull(event.getConnection(), "connection is null");
            callback.onLoggedOut(event.getPlayer(), event.getMultiPlayerGameMode(), event.getConnection());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientPlayerCopyCallback.class, ClientPlayerNetworkEvent.Clone.class, (callback, event) -> callback.onCopy(event.getOldPlayer(), event.getNewPlayer(), event.getMultiPlayerGameMode(), event.getConnection()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.Attack.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, event) -> {
            EventResult eventResult;
            if (!event.isAttack()) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.hitResult != null && (eventResult = callback.onAttackInteraction(minecraft, minecraft.player, minecraft.hitResult)).isInterrupt()) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.Use.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, event) -> {
            EventResult eventResult;
            if (!event.isUseItem()) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.hitResult != null && minecraft.player.getItemInHand(event.getHand()).isItemEnabled(minecraft.level.enabledFeatures()) && (minecraft.hitResult.getType() != HitResult.Type.ENTITY || minecraft.level.getWorldBorder().isWithinBounds(((EntityHitResult)minecraft.hitResult).getEntity().blockPosition())) && (eventResult = callback.onUseInteraction(minecraft, minecraft.player, event.getHand(), minecraft.hitResult)).isInterrupt()) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.Pick.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, event) -> {
            if (!event.isPickBlock()) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            EventResult eventResult = callback.onPickInteraction(minecraft, minecraft.player, minecraft.hitResult);
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLevelEvents.Load.class, LevelEvent.Load.class, (callback, event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onLevelLoad(Minecraft.getInstance(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ClientLevelEvents.Unload.class, LevelEvent.Unload.class, (callback, event) -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (!(patt0$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel clientLevel = (ClientLevel)patt0$temp;
            callback.onLevelUnload(Minecraft.getInstance(), clientLevel);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(MovementInputUpdateCallback.class, MovementInputUpdateEvent.class, (callback, event) -> callback.onMovementInputUpdate((LocalPlayer)event.getEntity(), event.getInput()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderBlockOverlayCallback.class, RenderBlockScreenEffectEvent.class, (callback, event) -> {
            EventResult eventResult = callback.onRenderBlockOverlay((LocalPlayer)event.getPlayer(), event.getPoseStack(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), event.getBlockState());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(FogEvents.Setup.class, ViewportEvent.RenderFog.class, (callback, event) -> callback.onSetupFog(event.getCamera(), (float)event.getPartialTick(), event.getEnvironment(), event.getType(), event.getFogData()));
        NeoForgeEventInvokerRegistry.INSTANCE.register(FogEvents.Color.class, ViewportEvent.ComputeFogColor.class, (callback, event) -> {
            MutableFloat red = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFogColor)event).setRed(arg_0), () -> ((ViewportEvent.ComputeFogColor)event).getRed());
            MutableFloat green = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFogColor)event).setGreen(arg_0), () -> ((ViewportEvent.ComputeFogColor)event).getGreen());
            MutableFloat blue = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFogColor)event).setBlue(arg_0), () -> ((ViewportEvent.ComputeFogColor)event).getBlue());
            callback.onComputeFogColor(event.getCamera(), (float)event.getPartialTick(), red, green, blue);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(RenderTooltipCallback.class, RenderTooltipEvent.Pre.class, (callback, event) -> {
            EventResult eventResult = callback.onRenderTooltip(event.getGraphics(), event.getFont(), event.getX(), event.getY(), event.getComponents(), event.getTooltipPositioner());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(SubmitBlockOutlineCallback.class, ExtractBlockOutlineRenderStateEvent.class, (callback, event) -> {
            EventResultHolder<@Nullable SubmitBlockOutlineCallback.CustomBlockOutlineRenderer> eventResult = callback.onSubmitBlockOutline(event.getLevelRenderer(), event.getLevel(), event.getBlockState(), event.getHitResult(), event.getCollisionContext(), event.getCamera());
            eventResult.ifDeny(customRenderer -> {
                Preconditions.checkArgument((customRenderer == null ? 1 : 0) != 0, (Object)"custom block outline renderer is not null");
                event.setCanceled(true);
            });
            eventResult.ifAllow(customRenderer -> {
                Objects.requireNonNull(customRenderer, "custom block outline renderer is null");
                event.addCustomRenderer(customRenderer::render);
            });
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(GameRenderEvents.Before.class, RenderFrameEvent.Pre.class, (callback, event) -> {
            Minecraft minecraft = Minecraft.getInstance();
            callback.onBeforeGameRender(minecraft, minecraft.gameRenderer, event.getPartialTick());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(GameRenderEvents.After.class, RenderFrameEvent.Post.class, (callback, event) -> {
            Minecraft minecraft = Minecraft.getInstance();
            callback.onAfterGameRender(minecraft, minecraft.gameRenderer, event.getPartialTick());
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(AddToastCallback.class, ToastAddEvent.class, (callback, event) -> {
            Minecraft minecraft = Minecraft.getInstance();
            EventResult eventResult = callback.onAddToast(minecraft.getToastManager(), event.getToast());
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ComputeFieldOfViewCallback.class, ViewportEvent.ComputeFov.class, (callback, event) -> {
            MutableFloat fieldOfView = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFov)event).setFOV(arg_0), () -> ((ViewportEvent.ComputeFov)event).getFOV());
            callback.onComputeFieldOfView(event.getRenderer(), event.getCamera(), (float)event.getPartialTick(), fieldOfView);
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(ChatMessageReceivedCallback.class, ClientChatReceivedEvent.class, (callback, event) -> {
            ClientChatReceivedEvent.System system;
            PlayerChatMessage playerChatMessage;
            MutableValue<Component> message = MutableValue.fromEvent(arg_0 -> ((ClientChatReceivedEvent)event).setMessage(arg_0), () -> ((ClientChatReceivedEvent)event).getMessage());
            if (event instanceof ClientChatReceivedEvent.Player) {
                ClientChatReceivedEvent.Player player = (ClientChatReceivedEvent.Player)event;
                playerChatMessage = player.getPlayerChatMessage();
            } else {
                playerChatMessage = null;
            }
            PlayerChatMessage playerChatMessage2 = playerChatMessage;
            boolean isOverlay = event instanceof ClientChatReceivedEvent.System && (system = (ClientChatReceivedEvent.System)event).isOverlay();
            EventResult eventResult = callback.onChatMessageReceived(message, event.getBoundChatType(), playerChatMessage2, isOverlay);
            if (eventResult.isInterrupt()) {
                event.setCanceled(true);
            }
        });
        NeoForgeEventInvokerRegistry.INSTANCE.register(GatherEffectScreenTooltipCallback.class, GatherEffectScreenTooltipsEvent.class, (callback, event) -> callback.onGatherEffectScreenTooltip(event.getScreen(), event.getEffectInstance(), event.getTooltip()));
    }

    private static <T, E extends ScreenEvent> void registerScreenEvent(Class<T> clazz, Class<E> eventClazz, BiConsumer<T, E> converter) {
        NeoForgeEventInvokerRegistry.INSTANCE.register(clazz, eventClazz, (callback, event, context) -> {
            Objects.requireNonNull(context, "context is null");
            if (!((Class)context).isInstance(event.getScreen())) {
                return;
            }
            converter.accept(callback, event);
        });
    }
}

