/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.tooltip;

import fuzs.puzzleslib.api.client.event.v1.gui.ItemTooltipCallback;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class ItemTooltipRegistry<T> {
    public static final ItemTooltipRegistry<class_2248> BLOCK = new ItemTooltipRegistry<class_2248>(){

        @Override
        @Nullable
        class_2248 getFromItemStack(class_1799 itemStack) {
            class_2248 class_22482;
            class_1792 class_17922 = itemStack.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                class_22482 = blockItem.method_7711();
            } else {
                class_22482 = null;
            }
            return class_22482;
        }

        @Override
        class_2378<class_2248> getRegistry() {
            return class_7923.field_41175;
        }
    };
    public static final ItemTooltipRegistry<class_1792> ITEM = new ItemTooltipRegistry<class_1792>(){

        @Override
        class_1792 getFromItemStack(class_1799 itemStack) {
            return itemStack.method_7909();
        }

        @Override
        class_2378<class_1792> getRegistry() {
            return class_7923.field_41178;
        }
    };

    ItemTooltipRegistry() {
    }

    @Nullable
    abstract T getFromItemStack(class_1799 var1);

    abstract class_2378<T> getRegistry();

    public <V extends T> void registerItemTooltip(V value, class_2561 component) {
        this.registerItemTooltip(value, new class_2561[]{component});
    }

    public <V extends T> void registerItemTooltip(Class<V> clazz, class_2561 component) {
        this.registerItemTooltip(clazz, new class_2561[]{component});
    }

    public void registerItemTooltip(class_6862<T> tagKey, class_2561 component) {
        this.registerItemTooltip(tagKey, new class_2561[]{component});
    }

    public <V extends T> void registerItemTooltip(V value, class_2561 ... components) {
        this.registerItemTooltipLines(value, (V valueX) -> Arrays.asList(components));
    }

    public <V extends T> void registerItemTooltip(Class<V> clazz, class_2561 ... components) {
        this.registerItemTooltipLines(clazz, (V valueX) -> Arrays.asList(components));
    }

    public void registerItemTooltip(class_6862<T> tagKey, class_2561 ... components) {
        this.registerItemTooltipLines(tagKey, (T valueX) -> Arrays.asList(components));
    }

    public <V extends T> void registerItemTooltip(V value, Function<V, @Nullable class_2561> componentExtractor) {
        this.registerItemTooltipLines(value, (V valueX) -> Collections.singletonList((class_2561)componentExtractor.apply(valueX)));
    }

    public <V extends T> void registerItemTooltip(Class<V> clazz, Function<V, @Nullable class_2561> componentExtractor) {
        this.registerItemTooltipLines(clazz, (V valueX) -> Collections.singletonList((class_2561)componentExtractor.apply(valueX)));
    }

    public void registerItemTooltip(class_6862<T> tagKey, Function<T, @Nullable class_2561> componentExtractor) {
        this.registerItemTooltipLines(tagKey, (T valueX) -> Collections.singletonList((class_2561)componentExtractor.apply(valueX)));
    }

    public <V extends T> void registerItemTooltipLines(V value, Function<V, List<class_2561>> componentExtractor) {
        this.registerItemTooltip((class_1799 itemStack) -> this.getFromItemStack((class_1799)itemStack) == value, (class_1799 itemStack, class_1792.class_9635 context, class_1836 tooltipFlag, class_1657 player, Consumer<class_2561> tooltipLineConsumer) -> ((List)componentExtractor.apply(value)).forEach(tooltipLineConsumer));
    }

    public <V extends T> void registerItemTooltipLines(Class<V> clazz, Function<V, List<class_2561>> componentExtractor) {
        this.registerItemTooltip(clazz, (class_1799 itemStack, class_1792.class_9635 context, class_1836 tooltipFlag, class_1657 player, Consumer<class_2561> tooltipLineConsumer) -> {
            T value = this.getFromItemStack(itemStack);
            Objects.requireNonNull(value, "value from item stack " + String.valueOf(itemStack) + " is null");
            ((List)componentExtractor.apply(value)).forEach(tooltipLineConsumer);
        });
    }

    public void registerItemTooltipLines(class_6862<T> tagKey, Function<T, List<class_2561>> componentExtractor) {
        this.registerItemTooltip(tagKey, (class_1799 itemStack, class_1792.class_9635 context, class_1836 tooltipFlag, class_1657 player, Consumer<class_2561> tooltipLineConsumer) -> {
            T value = this.getFromItemStack(itemStack);
            Objects.requireNonNull(value, "value from item stack " + String.valueOf(itemStack) + " is null");
            ((List)componentExtractor.apply(value)).forEach(tooltipLineConsumer);
        });
    }

    public <V extends T> void registerItemTooltip(Class<V> clazz, Provider provider) {
        for (Object value : this.getRegistry()) {
            if (!clazz.isInstance(value)) continue;
            this.registerItemTooltip((class_1799 itemStack) -> this.getFromItemStack((class_1799)itemStack) == value, provider);
        }
    }

    public void registerItemTooltip(class_6862<T> tagKey, Provider provider) {
        this.registerItemTooltip((class_1799 itemStack) -> {
            T value = this.getFromItemStack((class_1799)itemStack);
            return value != null && this.getRegistry().method_47983(value).method_40220(tagKey);
        }, provider);
    }

    public void registerItemTooltip(Predicate<class_1799> itemStackFilter, Provider provider) {
        ItemTooltipCallback.EVENT.register((itemStack, tooltipLines, tooltipContext, player, tooltipFlag) -> {
            if (tooltipContext != class_1792.class_9635.field_51353 && tooltipContext.method_59527() != null && itemStackFilter.test(itemStack)) {
                int originalSize = tooltipLines.size();
                provider.appendHoverText(itemStack, tooltipContext, tooltipFlag, player, component -> {
                    if (component != null) {
                        tooltipLines.addAll(tooltipLines.isEmpty() ? 0 : 1 + tooltipLines.size() - originalSize, ClientComponentSplitter.splitTooltipComponents(new class_5348[]{component}));
                    }
                });
            }
        });
    }

    @FunctionalInterface
    public static interface Provider {
        public void appendHoverText(class_1799 var1, class_1792.class_9635 var2, class_1836 var3, @Nullable class_1657 var4, Consumer<class_2561> var5);
    }
}

