/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.attachment.v4;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.attachment.v4.DataAttachmentType;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.impl.attachment.DataAttachmentRegistryImpl;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class DataAttachmentRegistry {
    private DataAttachmentRegistry() {
    }

    public static <V> EntityBuilder<V> entityBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getEntityTypeBuilder();
    }

    public static <V> BlockEntityBuilder<V> blockEntityBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getBlockEntityTypeBuilder();
    }

    public static <V> Builder<class_2818, V> levelChunkBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getLevelChunkBuilder();
    }

    public static <V> Builder<class_1937, V> levelBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getLevelBuilder();
    }

    public static interface EntityBuilder<V>
    extends RegistryBuilder<class_1297, V> {
        public EntityBuilder<V> persistent(Codec<V> var1);

        default public EntityBuilder<V> defaultValue(V defaultValue) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue(defaultValue);
        }

        default public EntityBuilder<V> defaultValue(Function<class_5455, V> defaultValueProvider) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue((Function)defaultValueProvider);
        }

        default public EntityBuilder<V> defaultValue(Class<? extends class_1297> holderType, V defaultValue) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue(holderType, defaultValue);
        }

        default public EntityBuilder<V> defaultValue(class_1299<?> entityType, V defaultValue) {
            return this.defaultValue(entity -> entity.method_5864() == entityType, (Object)defaultValue);
        }

        default public EntityBuilder<V> defaultValue(Predicate<class_1297> defaultFilter, V defaultValue) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue(defaultFilter, defaultValue);
        }

        public EntityBuilder<V> defaultValue(Predicate<class_1297> var1, Function<class_5455, V> var2);

        default public EntityBuilder<V> networkSynchronized(class_9139<? super class_9129, V> streamCodec) {
            return this.networkSynchronized(streamCodec, null);
        }

        public EntityBuilder<V> networkSynchronized(class_9139<? super class_9129, V> var1, @Nullable Function<class_1297, PlayerSet> var2);

        public EntityBuilder<V> copyOnDeath();
    }

    public static interface BlockEntityBuilder<V>
    extends RegistryBuilder<class_2586, V> {
        default public BlockEntityBuilder<V> defaultValue(V defaultValue) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue(defaultValue);
        }

        default public BlockEntityBuilder<V> defaultValue(Function<class_5455, V> defaultValueProvider) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue((Function)defaultValueProvider);
        }

        default public BlockEntityBuilder<V> defaultValue(Class<? extends class_2586> holderType, V defaultValue) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue(holderType, defaultValue);
        }

        default public BlockEntityBuilder<V> defaultValue(class_2591<?> blockEntityType, V defaultValue) {
            return this.defaultValue(blockEntity -> blockEntity.method_11017() == blockEntityType, (Object)defaultValue);
        }

        default public BlockEntityBuilder<V> defaultValue(Predicate<class_2586> defaultFilter, V defaultValue) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue(defaultFilter, defaultValue);
        }

        public BlockEntityBuilder<V> defaultValue(Predicate<class_2586> var1, Function<class_5455, V> var2);

        public BlockEntityBuilder<V> persistent(Codec<V> var1);
    }

    public static interface Builder<T, V> {
        default public Builder<T, V> defaultValue(V defaultValue) {
            return this.defaultValue(registries -> defaultValue);
        }

        public Builder<T, V> defaultValue(Function<class_5455, V> var1);

        public Builder<T, V> persistent(Codec<V> var1);

        public DataAttachmentType<T, V> build(class_2960 var1);
    }

    public static interface RegistryBuilder<T, V>
    extends Builder<T, V> {
        @Override
        default public RegistryBuilder<T, V> defaultValue(Function<class_5455, V> defaultValueProvider) {
            return this.defaultValue((Predicate<T>)Predicates.alwaysTrue(), defaultValueProvider);
        }

        default public RegistryBuilder<T, V> defaultValue(Class<? extends T> holderType, V defaultValue) {
            return this.defaultValue(holderType::isInstance, defaultValue);
        }

        default public RegistryBuilder<T, V> defaultValue(Predicate<T> defaultFilter, V defaultValue) {
            return this.defaultValue(defaultFilter, registries -> defaultValue);
        }

        public RegistryBuilder<T, V> defaultValue(Predicate<T> var1, Function<class_5455, V> var2);
    }
}

