/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.core.v1;

import fuzs.puzzleslib.api.client.core.v1.context.AdditionalModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockColorsContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.core.v1.context.ClientTooltipComponentsContext;
import fuzs.puzzleslib.api.client.core.v1.context.CoreShadersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntitySpectatorShadersContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemDecorationsContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.core.v1.context.ParticleProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderBuffersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import fuzs.puzzleslib.api.client.core.v1.context.SkullRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.SpecialBlockModelRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.SpecialBlockModelTypesContext;
import fuzs.puzzleslib.api.core.v1.BaseModConstructor;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.core.ClientFactories;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.apache.logging.log4j.util.Strings;

public interface ClientModConstructor
extends BaseModConstructor {
    public static void construct(String modId, Supplier<ClientModConstructor> modConstructorSupplier) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("mod id is empty");
        }
        ClientModConstructor modConstructor = modConstructorSupplier.get();
        ModContext modContext = ModContext.get(modId);
        class_2960 resourceLocation = ModContext.getPairingIdentifier(modId, modConstructor);
        modContext.scheduleClientModConstruction(resourceLocation, () -> {
            PuzzlesLib.LOGGER.info("Constructing client components for {}", (Object)resourceLocation);
            ClientFactories.INSTANCE.constructClientMod(modId, modConstructor);
        });
    }

    default public void onConstructMod() {
    }

    default public void onClientSetup() {
    }

    default public void onRegisterEntityRenderers(EntityRenderersContext context) {
    }

    default public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
    }

    default public void onRegisterClientTooltipComponents(ClientTooltipComponentsContext context) {
    }

    default public void onRegisterParticleProviders(ParticleProvidersContext context) {
    }

    default public void onRegisterMenuScreens(MenuScreensContext context) {
    }

    default public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
    }

    default public void onRegisterAdditionalModels(AdditionalModelsContext context) {
    }

    default public void onRegisterBlockStateResolver(BlockStateResolverContext context) {
    }

    default public void onRegisterItemDecorations(ItemDecorationsContext context) {
    }

    default public void onRegisterEntitySpectatorShaders(EntitySpectatorShadersContext context) {
    }

    default public void onRegisterItemModels(ItemModelsContext context) {
    }

    @Deprecated(forRemoval=true)
    default public void onRegisterSpecialBlockModelTypes(SpecialBlockModelTypesContext context) {
    }

    default public void onRegisterSpecialBlockModelRenderers(SpecialBlockModelRenderersContext context) {
    }

    default public void onRegisterSkullRenderers(SkullRenderersContext context) {
    }

    default public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
    }

    default public void onRegisterKeyMappings(KeyMappingsContext context) {
    }

    default public void onRegisterBlockRenderTypes(RenderTypesContext<class_2248> context) {
    }

    default public void onRegisterFluidRenderTypes(RenderTypesContext<class_3611> context) {
    }

    default public void onRegisterBlockColorProviders(BlockColorsContext context) {
    }

    default public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
    }

    default public void onRegisterCoreShaders(CoreShadersContext context) {
    }

    default public void onRegisterRenderBuffers(RenderBuffersContext context) {
    }
}

