/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.searchtree.v1;

import fuzs.puzzleslib.api.client.searchtree.v1.SearchTreeType;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1124;
import net.minecraft.class_1129;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

public final class SearchRegistryHelper {
    private static final Map<SearchTreeType<?>, Entry<?>> SEARCH_TREES = new IdentityHashMap();

    private SearchRegistryHelper() {
    }

    public static <T> void register(SearchTreeType<T> type, Function<List<T>, class_1129<T>> factory) {
        SEARCH_TREES.put(type, new Entry<T>(factory));
    }

    public static Stream<String> getTooltipLines(class_1799 itemStack) {
        return SearchRegistryHelper.getTooltipLines(Stream.of(itemStack), (class_1836)class_1836.field_41070);
    }

    public static Stream<String> getTooltipLines(Stream<class_1799> stream, class_1836 tooltipFlag) {
        class_5455.class_6890 registries = Proxy.INSTANCE.getClientPacketListener().method_29091();
        return class_1124.method_60356(stream, (class_1792.class_9635)class_1792.class_9635.method_59530((class_7225.class_7874)registries), (class_1836)tooltipFlag);
    }

    public static <T> void populateSearchTree(SearchTreeType<T> type, List<T> values) {
        Entry<T> entry = SearchRegistryHelper.lookupEntry(type);
        Proxy.INSTANCE.getClientPacketListener().method_60347().method_60353(entry.key, () -> {
            CompletableFuture searchTree = entry.searchTree;
            entry.searchTree = CompletableFuture.supplyAsync(() -> entry.factory.apply(values), (Executor)class_156.method_18349());
            searchTree.cancel(true);
        });
    }

    public static <T> class_1129<T> getSearchTree(SearchTreeType<T> type) {
        return SearchRegistryHelper.lookupEntry(type).searchTree.join();
    }

    private static <T> Entry<T> lookupEntry(SearchTreeType<T> type) {
        Entry<?> entry = SEARCH_TREES.get(type);
        Objects.requireNonNull(entry, () -> "Search tree type " + String.valueOf(type.resourceLocation()) + " is not registered");
        return entry;
    }

    private static class Entry<T> {
        public final class_1124.class_1125 key = new class_1124.class_1125();
        public final Function<List<T>, class_1129<T>> factory;
        public CompletableFuture<class_1129<T>> searchTree = CompletableFuture.completedFuture(class_1129.empty());

        Entry(Function<List<T>, class_1129<T>> factory) {
            this.factory = factory;
        }
    }
}

