/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public final class RegistryHelper {
    private RegistryHelper() {
    }

    public static <T> class_2378<T> findBuiltInRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        class_2378<T> registry = RegistryHelper.findNullableBuiltInRegistry(registryKey);
        Objects.requireNonNull(registry, () -> "registry for %s is null".formatted(registryKey));
        return registry;
    }

    @Nullable
    public static <T> class_2378<T> findNullableBuiltInRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        return (class_2378)class_7923.field_41167.method_29107(registryKey);
    }

    public static <T> class_2378<T> findGameRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        class_2378<T> registry = RegistryHelper.findNullableGameRegistry(registryKey);
        Objects.requireNonNull(registry, () -> "registry for %s is null".formatted(registryKey));
        return registry;
    }

    public static <T> class_2378<T> findNullableGameRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        Optional<class_2378<T>> registry = Optional.empty();
        MinecraftServer minecraftServer = CommonAbstractions.INSTANCE.getMinecraftServer();
        if (minecraftServer != null) {
            registry = minecraftServer.method_30611().method_46759(registryKey);
        }
        if (registry.isEmpty()) {
            registry = Optional.ofNullable(RegistryHelper.findNullableBuiltInRegistry(registryKey));
        }
        return registry.orElse(null);
    }

    public static <T> Optional<class_5321<T>> getResourceKey(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelper.getHolderReference(registryKey, object).map(class_6880.class_6883::method_40237);
    }

    public static <T> Optional<class_5321<T>> getResourceKey(class_2378<T> registry, T object) {
        return RegistryHelper.getHolderReference(registry, object).map(class_6880.class_6883::method_40237);
    }

    public static <T> class_5321<T> getResourceKeyOrThrow(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelper.getResourceKey(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registryKey) + ": " + String.valueOf(object)));
    }

    public static <T> class_5321<T> getResourceKeyOrThrow(class_2378<T> registry, T object) {
        return RegistryHelper.getResourceKey(registry, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registry.method_46765()) + ": " + String.valueOf(object)));
    }

    public static <T> Optional<class_6880.class_6883<T>> getHolderReference(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return Optional.ofNullable(RegistryHelper.getBuiltInRegistryHolder(object)).or(() -> {
            class_2378 registry = RegistryHelper.findGameRegistry(registryKey);
            return registry.method_29113(object).flatMap(arg_0 -> registry.method_46746(arg_0));
        });
    }

    public static <T> Optional<class_6880.class_6883<T>> getHolderReference(class_2378<T> registry, T object) {
        return Optional.ofNullable(RegistryHelper.getBuiltInRegistryHolder(object)).or(() -> registry.method_29113(object).flatMap(arg_0 -> ((class_2378)registry).method_46746(arg_0)));
    }

    public static <T> class_6880.class_6883<T> getHolderOrThrow(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelper.getHolderReference(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registryKey) + ": " + String.valueOf(object)));
    }

    public static <T> class_6880.class_6883<T> getHolderOrThrow(class_2378<T> registry, T object) {
        return RegistryHelper.getHolderReference(registry, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registry.method_46765()) + ": " + String.valueOf(object)));
    }

    public static <T> class_6880<T> wrapAsHolder(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelper.findGameRegistry(registryKey).method_47983(object);
    }

    public static <T> boolean is(class_6862<T> tagKey, T object) {
        class_6880.class_6883<T> holder = RegistryHelper.getBuiltInRegistryHolder(object);
        if (holder != null) {
            return holder.method_40220(tagKey);
        }
        class_2378<T> registry = RegistryHelper.findGameRegistry(tagKey.comp_326());
        return tagKey.method_41007(registry.method_46765()) && registry.method_47983(object).method_40220(tagKey);
    }

    @Nullable
    public static <T> class_6880.class_6883<T> getBuiltInRegistryHolder(T object) {
        T t = object;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2248.class, class_1792.class, class_1299.class, class_3611.class, class_2591.class}, t2, n)) {
            case 0 -> {
                class_2248 block = (class_2248)t2;
                yield block.method_40142();
            }
            case 1 -> {
                class_1792 item = (class_1792)t2;
                yield item.method_40131();
            }
            case 2 -> {
                class_1299 entityType = (class_1299)t2;
                yield entityType.method_40124();
            }
            case 3 -> {
                class_3611 fluid = (class_3611)t2;
                yield fluid.method_40178();
            }
            case 4 -> {
                class_2591 blockEntityType = (class_2591)t2;
                yield blockEntityType.method_53254();
            }
            default -> null;
        };
    }
}

