/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.core.v1.utility.EnvironmentAwareBuilder;
import fuzs.puzzleslib.api.init.v3.registry.ExtendedMenuSupplier;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.init.DyedSpawnEggItem;
import fuzs.puzzleslib.impl.item.CreativeModeTabHelper;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_10355;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_156;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4158;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7701;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8110;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public interface RegistryManager
extends EnvironmentAwareBuilder<RegistryManager> {
    public static RegistryManager from(String modId) {
        return ModContext.get(modId).getRegistryManager();
    }

    default public <T> class_5321<T> makeResourceKey(class_5321<? extends class_2378<? super T>> registryKey, String path) {
        return class_5321.method_29179(registryKey, (class_2960)this.makeKey(path));
    }

    public class_2960 makeKey(String var1);

    default public String makeDescriptionId(class_5321<? extends class_2378<?>> registryKey, String path) {
        return class_156.method_646((String)class_7924.method_60915(registryKey), (class_2960)this.makeKey(path));
    }

    public <T> class_6880.class_6883<T> registerLazily(class_5321<? extends class_2378<? super T>> var1, String var2);

    public <T> class_6880.class_6883<T> register(class_5321<? extends class_2378<? super T>> var1, String var2, Supplier<T> var3);

    default public class_6880.class_6883<class_2248> registerBlock(String path, Supplier<class_4970.class_2251> blockPropertiesSupplier) {
        return this.registerBlock(path, class_2248::new, blockPropertiesSupplier);
    }

    default public class_6880.class_6883<class_2248> registerBlock(String path, Function<class_4970.class_2251, class_2248> blockFactory, Supplier<class_4970.class_2251> blockPropertiesSupplier) {
        return this.register(class_7924.field_41254, path, () -> (class_2248)blockFactory.apply(((class_4970.class_2251)blockPropertiesSupplier.get()).method_63500(this.makeResourceKey(class_7924.field_41254, path))));
    }

    default public class_6880.class_6883<class_1792> registerItem(String path) {
        return this.registerItem(path, class_1792.class_1793::new);
    }

    default public class_6880.class_6883<class_1792> registerItem(String path, Supplier<class_1792.class_1793> itemPropertiesSupplier) {
        return this.registerItem(path, class_1792::new, itemPropertiesSupplier);
    }

    default public class_6880.class_6883<class_1792> registerItem(String path, Function<class_1792.class_1793, class_1792> itemFactory) {
        return this.registerItem(path, itemFactory, class_1792.class_1793::new);
    }

    default public class_6880.class_6883<class_1792> registerItem(String path, Function<class_1792.class_1793, class_1792> itemFactory, Supplier<class_1792.class_1793> itemPropertiesSupplier) {
        return this.register(class_7924.field_41197, path, () -> (class_1792)itemFactory.apply(((class_1792.class_1793)itemPropertiesSupplier.get()).method_63686(this.makeResourceKey(class_7924.field_41197, path))));
    }

    default public class_6880.class_6883<class_1792> registerBlockItem(class_6880<class_2248> block) {
        return this.registerBlockItem(block, class_1792.class_1793::new);
    }

    default public class_6880.class_6883<class_1792> registerBlockItem(class_6880<class_2248> block, Supplier<class_1792.class_1793> itemPropertiesSupplier) {
        return this.registerBlockItem(block, class_1747::new, itemPropertiesSupplier);
    }

    default public class_6880.class_6883<class_1792> registerBlockItem(class_6880<class_2248> block, BiFunction<class_2248, class_1792.class_1793, ? extends class_1747> itemFactory) {
        return this.registerBlockItem(block, itemFactory, class_1792.class_1793::new);
    }

    default public class_6880.class_6883<class_1792> registerBlockItem(class_6880<class_2248> block, BiFunction<class_2248, class_1792.class_1793, ? extends class_1747> itemFactory, Supplier<class_1792.class_1793> itemPropertiesSupplier) {
        return this.registerItem(((class_5321)block.method_40230().orElseThrow()).method_29177().method_12832(), itemProperties -> (class_1792)itemFactory.apply((class_2248)block.comp_349(), (class_1792.class_1793)itemProperties), () -> ((class_1792.class_1793)itemPropertiesSupplier.get()).method_63685());
    }

    default public class_6880.class_6883<class_1792> registerSpawnEggItem(class_6880<? extends class_1299<? extends class_1308>> entityTypeHolder, int backgroundColor, int highlightColor) {
        return this.registerSpawnEggItem(entityTypeHolder, backgroundColor, highlightColor, class_1792.class_1793::new);
    }

    default public class_6880.class_6883<class_1792> registerSpawnEggItem(class_6880<? extends class_1299<? extends class_1308>> entityTypeHolder, int backgroundColor, int highlightColor, Supplier<class_1792.class_1793> itemPropertiesSupplier) {
        return this.registerItem(((class_5321)entityTypeHolder.method_40230().orElseThrow()).method_29177().method_12832() + "_spawn_egg", itemProperties -> new DyedSpawnEggItem((class_1299<? extends class_1308>)((class_1299)entityTypeHolder.comp_349()), backgroundColor, highlightColor, (class_1792.class_1793)itemProperties), itemPropertiesSupplier);
    }

    default public class_6880.class_6883<class_1761> registerCreativeModeTab(class_6880<? extends class_1935> iconHolder) {
        return this.registerCreativeModeTab(() -> new class_1799((class_1935)iconHolder.comp_349()));
    }

    default public class_6880.class_6883<class_1761> registerCreativeModeTab(Supplier<class_1799> iconSupplier) {
        class_2960 resourceLocation = this.makeKey("main");
        return this.registerCreativeModeTab(resourceLocation.method_12832(), iconSupplier, CreativeModeTabHelper.getDisplayItems(resourceLocation.method_12836()), false);
    }

    default public class_6880.class_6883<class_1761> registerCreativeModeTab(Supplier<class_1799> iconSupplier, class_1761.class_7914 displayItems) {
        return this.registerCreativeModeTab("main", iconSupplier, displayItems, false);
    }

    public class_6880.class_6883<class_1761> registerCreativeModeTab(String var1, Supplier<class_1799> var2, class_1761.class_7914 var3, boolean var4);

    default public <T> class_6880.class_6883<class_9331<T>> registerDataComponentType(String path, UnaryOperator<class_9331.class_9332<T>> entry) {
        return this.register(class_7924.field_49659, path, () -> ((class_9331.class_9332)entry.apply(class_9331.method_57873())).method_57880());
    }

    default public class_6880.class_6883<class_3611> registerFluid(String path, Supplier<class_3611> entry) {
        return this.register(class_7924.field_41270, path, entry);
    }

    default public class_6880.class_6883<class_1291> registerMobEffect(String path, Supplier<class_1291> entry) {
        return this.register(class_7924.field_41208, path, entry);
    }

    default public class_6880.class_6883<class_3414> registerSoundEvent(String path) {
        return this.register(class_7924.field_41225, path, () -> class_3414.method_47908((class_2960)this.makeKey(path)));
    }

    default public class_6880.class_6883<class_1842> registerPotion(String path, Supplier<class_1842> entry) {
        return this.registerPotion(path, (String s) -> (class_1842)entry.get());
    }

    default public class_6880.class_6883<class_1842> registerPotion(String path, Function<String, class_1842> entry) {
        return this.register(class_7924.field_41215, path, () -> (class_1842)entry.apply(path));
    }

    default public class_5321<class_1887> registerEnchantment(String path) {
        return this.makeResourceKey(class_7924.field_41265, path);
    }

    default public <T extends class_1297> class_6880.class_6883<class_1299<T>> registerEntityType(String path, Supplier<class_1299.class_1300<T>> entry) {
        return this.register(class_7924.field_41266, path, () -> ((class_1299.class_1300)entry.get()).method_5905(this.makeResourceKey(class_7924.field_41266, path)));
    }

    default public <T extends class_2586> class_6880.class_6883<class_2591<T>> registerBlockEntityType(String path, BiFunction<class_2338, class_2680, T> blockEntityFactory, class_6880<class_2248> validBlock) {
        return this.registerBlockEntityType(path, blockEntityFactory, () -> Collections.singleton((class_2248)validBlock.comp_349()));
    }

    @Deprecated(forRemoval=true)
    default public <T extends class_2586> class_6880.class_6883<class_2591<T>> registerBlockEntityType(String path, BiFunction<class_2338, class_2680, T> blockEntityFactory, class_6880<class_2248> ... validBlocks) {
        return this.registerBlockEntityType(path, blockEntityFactory, () -> Stream.of(validBlocks).map(class_6880::comp_349).collect(Collectors.toSet()));
    }

    public <T extends class_2586> class_6880.class_6883<class_2591<T>> registerBlockEntityType(String var1, BiFunction<class_2338, class_2680, T> var2, Supplier<Set<class_2248>> var3);

    default public <T extends class_1703> class_6880.class_6883<class_3917<T>> registerMenuType(String path, Supplier<class_3917.class_3918<T>> entry) {
        return this.register(class_7924.field_41207, path, () -> new class_3917((class_3917.class_3918)entry.get(), class_7701.field_40183));
    }

    public <T extends class_1703> class_6880.class_6883<class_3917<T>> registerExtendedMenuType(String var1, Supplier<ExtendedMenuSupplier<T>> var2);

    default public class_6880.class_6883<class_4158> registerPoiType(String path, class_6880<class_2248> matchingBlock) {
        return this.registerPoiType(path, () -> Collections.singleton((class_2248)matchingBlock.comp_349()));
    }

    @Deprecated(forRemoval=true)
    default public class_6880.class_6883<class_4158> registerPoiType(String path, class_6880<class_2248> ... matchingBlocks) {
        return this.registerPoiType(path, 0, 1, () -> Stream.of(matchingBlocks).map(class_6880::comp_349).flatMap(block -> block.method_9595().method_11662().stream()).collect(Collectors.toSet()));
    }

    default public class_6880.class_6883<class_4158> registerPoiType(String path, Supplier<Set<class_2248>> matchingBlocks) {
        return this.registerPoiType(path, 0, 1, () -> (Set)((Set)matchingBlocks.get()).stream().flatMap(block -> block.method_9595().method_11662().stream()).collect(ImmutableSet.toImmutableSet()));
    }

    public class_6880.class_6883<class_4158> registerPoiType(String var1, int var2, int var3, Supplier<Set<class_2680>> var4);

    default public <A extends ArgumentType<?>> class_6880.class_6883<class_2314<?, ?>> registerArgumentType(String path, Class<? extends A> argumentClass, Supplier<A> argumentType) {
        return this.registerArgumentType(path, argumentClass, (class_2314)class_2319.method_41999(argumentType));
    }

    public <A extends ArgumentType<?>, T extends class_2314.class_7217<A>> class_6880.class_6883<class_2314<?, ?>> registerArgumentType(String var1, Class<? extends A> var2, class_2314<A, T> var3);

    default public <T extends class_1860<?>> class_6880.class_6883<class_3956<T>> registerRecipeType(String path) {
        return this.register(class_7924.field_41217, path, () -> {
            final class_2960 resourceLocation = this.makeKey(path);
            return new class_3956<T>(this){

                public String toString() {
                    return "RecipeType[" + String.valueOf(resourceLocation) + "]";
                }
            };
        });
    }

    default public class_6880.class_6883<class_10355> registerRecipeBookCategory(String path) {
        return this.register(class_7924.field_54928, path, () -> {
            final class_2960 resourceLocation = this.makeKey(path);
            return new class_10355(this){

                public String toString() {
                    return "RecipeBookCategory[" + String.valueOf(resourceLocation) + "]";
                }
            };
        });
    }

    default public class_6880.class_6883<class_5712> registerGameEvent(String path, int notificationRadius) {
        return this.register(class_7924.field_41273, path, () -> new class_5712(notificationRadius));
    }

    default public class_6880.class_6883<class_2400> registerParticleType(String path) {
        return this.register(class_7924.field_41210, path, () -> new class_2400(false));
    }

    default public <T extends class_2394> class_6880.class_6883<class_2396<T>> registerParticleType(String path, boolean overrideLimiter, final Function<class_2396<T>, MapCodec<T>> codecGetter, final Function<class_2396<T>, class_9139<? super class_9129, T>> streamCodecGetter) {
        return this.register(class_7924.field_41210, path, () -> new class_2396<T>(this, overrideLimiter){

            public MapCodec<T> method_29138() {
                return (MapCodec)codecGetter.apply(this);
            }

            public class_9139<? super class_9129, T> method_56179() {
                return (class_9139)streamCodecGetter.apply(this);
            }
        });
    }

    default public class_6880.class_6883<class_1320> registerAttribute(String path, double defaultValue, double minValue, double maxValue) {
        return this.registerAttribute(path, defaultValue, minValue, maxValue, true, class_1320.class_9764.field_51885);
    }

    default public class_6880.class_6883<class_1320> registerAttribute(String path, double defaultValue, double minValue, double maxValue, boolean syncable, class_1320.class_9764 sentiment) {
        Objects.requireNonNull(sentiment, "sentiment is null");
        return this.register(class_7924.field_41251, path, () -> new class_1329(this.makeDescriptionId(class_7924.field_41251, path), defaultValue, minValue, maxValue).method_26829(syncable).method_60493(sentiment));
    }

    public <T> class_6880.class_6883<class_2941<T>> registerEntityDataSerializer(String var1, Supplier<class_2941<T>> var2);

    default public class_5321<class_8110> registerDamageType(String path) {
        return this.makeResourceKey(class_7924.field_42534, path);
    }

    default public class_5321<class_8054> registerTrimMaterial(String path) {
        return this.makeResourceKey(class_7924.field_42083, path);
    }

    default public class_5321<class_52> registerLootTable(String path) {
        return this.makeResourceKey(class_7924.field_50079, path);
    }
}

