/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10191;
import net.minecraft.class_10394;
import net.minecraft.class_156;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8051;

public final class ArmorMaterialBuilder {
    private static final class_2960 NO_RENDER_ASSET_ID = PuzzlesLibMod.id("no_render");
    private int durability;
    private Map<class_8051, Integer> defense = (Map)class_156.method_654(new EnumMap(class_8051.class), map -> {
        for (class_8051 armorType : class_8051.values()) {
            map.put(armorType, 0);
        }
    });
    private int enchantmentValue = 1;
    private class_6880<class_3414> equipSound = class_3417.field_14883;
    private float toughness;
    private float knockbackResistance;
    private class_6862<class_1792> repairIngredient;
    private class_5321<class_10394> assetId;

    private ArmorMaterialBuilder() {
    }

    public static ArmorMaterialBuilder of(class_6862<class_1792> repairIngredient) {
        return new ArmorMaterialBuilder().setRepairIngredient(repairIngredient);
    }

    public static ArmorMaterialBuilder of(class_2960 assetId, class_6862<class_1792> repairIngredient) {
        return new ArmorMaterialBuilder().setAssetId(assetId).setRepairIngredient(repairIngredient);
    }

    @Deprecated(forRemoval=true)
    public static ArmorMaterialBuilder of(class_5321<class_10394> assetId, class_6862<class_1792> repairIngredient) {
        return new ArmorMaterialBuilder().setAssetId(assetId).setRepairIngredient(repairIngredient);
    }

    public static ArmorMaterialBuilder copyOf(class_1741 armorMaterial) {
        return ArmorMaterialBuilder.of((class_5321<class_10394>)armorMaterial.comp_3168(), (class_6862<class_1792>)armorMaterial.comp_2301()).setDurability(armorMaterial.comp_3166()).setDefense(armorMaterial.comp_2298()).setEnchantmentValue(armorMaterial.comp_3167()).setEquipSound((class_6880<class_3414>)armorMaterial.comp_2300()).setToughness(armorMaterial.comp_2303()).setKnockbackResistance(armorMaterial.comp_2304());
    }

    public ArmorMaterialBuilder setDurability(int durability) {
        this.durability = durability;
        return this;
    }

    public ArmorMaterialBuilder setDefense(int defense) {
        return this.setDefense(defense, defense, defense, defense, defense);
    }

    public ArmorMaterialBuilder setDefense(int boots, int leggings, int chestplate, int helmet) {
        return this.setDefense(boots, leggings, chestplate, helmet, 0);
    }

    public ArmorMaterialBuilder setDefense(int boots, int leggings, int chestplate, int helmet, int body) {
        return this.setDefense(class_8051.field_41937, boots).setDefense(class_8051.field_41936, leggings).setDefense(class_8051.field_41935, chestplate).setDefense(class_8051.field_41934, helmet).setDefense(class_8051.field_48838, body);
    }

    public ArmorMaterialBuilder setDefense(class_8051 armorType, int defense) {
        this.defense.put(armorType, defense);
        return this;
    }

    private ArmorMaterialBuilder setDefense(Map<class_8051, Integer> defense) {
        this.defense = defense;
        return this;
    }

    public ArmorMaterialBuilder setEnchantmentValue(int enchantmentValue) {
        this.enchantmentValue = enchantmentValue;
        return this;
    }

    public ArmorMaterialBuilder setEquipSound(class_6880<class_3414> equipSound) {
        Objects.requireNonNull(equipSound, "equip sound is null");
        this.equipSound = equipSound;
        return this;
    }

    public ArmorMaterialBuilder setToughness(float toughness) {
        this.toughness = toughness;
        return this;
    }

    public ArmorMaterialBuilder setKnockbackResistance(float knockbackResistance) {
        this.knockbackResistance = knockbackResistance;
        return this;
    }

    public ArmorMaterialBuilder setRepairIngredient(class_6862<class_1792> repairIngredient) {
        Objects.requireNonNull(repairIngredient, "repair ingredient is null");
        this.repairIngredient = repairIngredient;
        return this;
    }

    public ArmorMaterialBuilder setAssetId(class_2960 assetId) {
        Objects.requireNonNull(assetId, "asset id is null");
        return this.setAssetId((class_5321<class_10394>)class_5321.method_29179((class_5321)class_10191.field_55214, (class_2960)assetId));
    }

    public ArmorMaterialBuilder setAssetId(class_5321<class_10394> assetId) {
        Objects.requireNonNull(assetId, "asset id is null");
        this.assetId = assetId;
        return this;
    }

    public ArmorMaterialBuilder setNoAssetId() {
        return this.setAssetId(NO_RENDER_ASSET_ID);
    }

    public class_1741 build() {
        Objects.requireNonNull(this.defense, "defense map is null");
        Objects.requireNonNull(this.equipSound, "equip sound is null");
        Objects.requireNonNull(this.repairIngredient, "repair ingredient is null");
        Objects.requireNonNull(this.assetId, "asset id is null");
        return new class_1741(this.durability, (Map)Maps.immutableEnumMap(this.defense), this.enchantmentValue, this.equipSound, this.toughness, this.knockbackResistance, this.repairIngredient, this.assetId);
    }
}

