/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.client.event;

import fuzs.puzzleslib.api.client.event.v1.gui.RenderGuiEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderGuiLayerEvents;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.fabric.api.client.event.v1.FabricGuiEvents;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public final class FabricGuiEventHelper {
    private static final String KEY_GUI_LEFT_HEIGHT = PuzzlesLibMod.id("left_height").toString();
    private static final String KEY_GUI_RIGHT_HEIGHT = PuzzlesLibMod.id("right_height").toString();
    private static final Set<class_2960> CANCELLED_GUI_LAYERS = new HashSet<class_2960>();

    private FabricGuiEventHelper() {
    }

    private static void invokeGuiLayerEvents(class_329 gui, class_332 guiGraphics, class_9779 deltaTracker) {
        if (gui.field_2035.field_1690.field_1842) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 50.0f);
        for (class_2960 resourceLocation : RenderGuiLayerEvents.VANILLA_GUI_LAYERS_VIEW) {
            if (((RenderGuiLayerEvents.Before)FabricGuiEvents.beforeRenderGuiElement(resourceLocation).invoker()).onBeforeRenderGuiLayer(gui, guiGraphics, deltaTracker).isInterrupt()) {
                CANCELLED_GUI_LAYERS.add(resourceLocation);
            } else {
                ((RenderGuiLayerEvents.After)FabricGuiEvents.afterRenderGuiElement(resourceLocation).invoker()).onAfterRenderGuiLayer(gui, guiGraphics, deltaTracker);
            }
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        }
        guiGraphics.method_51448().method_22909();
    }

    public static void cancelIfNecessary(class_2960 resourceLocation, CallbackInfo callback) {
        if (CANCELLED_GUI_LAYERS.contains(resourceLocation)) {
            callback.cancel();
        }
    }

    public static int getGuiLeftHeight() {
        int n;
        Object object = FabricLoader.getInstance().getObjectShare().get(KEY_GUI_LEFT_HEIGHT);
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            n = i;
        } else {
            n = 0;
        }
        return n;
    }

    public static int getGuiRightHeight() {
        int n;
        Object object = FabricLoader.getInstance().getObjectShare().get(KEY_GUI_RIGHT_HEIGHT);
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            n = i;
        } else {
            n = 0;
        }
        return n;
    }

    public static void setGuiLeftHeight(int leftHeight) {
        FabricLoader.getInstance().getObjectShare().put(KEY_GUI_LEFT_HEIGHT, (Object)leftHeight);
    }

    public static void setGuiRightHeight(int rightHeight) {
        FabricLoader.getInstance().getObjectShare().put(KEY_GUI_RIGHT_HEIGHT, (Object)rightHeight);
    }

    public static void registerEventHandlers() {
        RenderGuiEvents.BEFORE.register(EventPhase.FIRST, (minecraft, guiGraphics, deltaTracker) -> {
            CANCELLED_GUI_LAYERS.clear();
            FabricGuiEventHelper.setGuiLeftHeight(39);
            FabricGuiEventHelper.setGuiRightHeight(39);
        });
        RenderGuiEvents.BEFORE.register(EventPhase.AFTER, FabricGuiEventHelper::invokeGuiLayerEvents);
        RenderGuiLayerEvents.after(RenderGuiLayerEvents.PLAYER_HEALTH).register(EventPhase.FIRST, (gui, guiGraphics, deltaTracker) -> {
            class_1297 patt0$temp;
            if (gui.field_2035.field_1761.method_2908() && (patt0$temp = gui.field_2035.method_1560()) instanceof class_1657) {
                class_1657 player = (class_1657)patt0$temp;
                int playerHealth = class_3532.method_15386((float)player.method_6032());
                float maxHealth = Math.max((float)player.method_45325(class_5134.field_23716), (float)Math.max(gui.field_2033, playerHealth));
                int absorptionAmount = class_3532.method_15386((float)player.method_6067());
                int healthRows = class_3532.method_15386((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
                int healthRowShift = Math.max(10 - (healthRows - 2), 3);
                FabricGuiEventHelper.setGuiLeftHeight(FabricGuiEventHelper.getGuiLeftHeight() + 10 + (healthRows - 1) * healthRowShift);
            }
        });
        RenderGuiLayerEvents.after(RenderGuiLayerEvents.ARMOR_LEVEL).register(EventPhase.FIRST, (gui, guiGraphics, deltaTracker) -> {
            class_1657 player;
            class_1297 patt0$temp;
            if (gui.field_2035.field_1761.method_2908() && (patt0$temp = gui.field_2035.method_1560()) instanceof class_1657 && (player = (class_1657)patt0$temp).method_6096() > 0) {
                FabricGuiEventHelper.setGuiLeftHeight(FabricGuiEventHelper.getGuiLeftHeight() + 10);
            }
        });
        RenderGuiLayerEvents.after(RenderGuiLayerEvents.FOOD_LEVEL).register(EventPhase.FIRST, (gui, guiGraphics, deltaTracker) -> {
            class_1309 livingEntity;
            if (gui.field_2035.field_1761.method_2908() && gui.field_2035.method_1560() instanceof class_1657 && gui.method_1744(livingEntity = gui.method_1734()) == 0) {
                FabricGuiEventHelper.setGuiRightHeight(FabricGuiEventHelper.getGuiRightHeight() + 10);
            }
        });
        RenderGuiLayerEvents.after(RenderGuiLayerEvents.AIR_LEVEL).register(EventPhase.FIRST, (gui, guiGraphics, deltaTracker) -> {
            class_1297 patt0$temp;
            if (gui.field_2035.field_1761.method_2908() && (patt0$temp = gui.field_2035.method_1560()) instanceof class_1657) {
                class_1657 player = (class_1657)patt0$temp;
                int maxAirSupply = player.method_5748();
                int airSupply = Math.min(player.method_5669(), maxAirSupply);
                if (player.method_5777(class_3486.field_15517) || airSupply < maxAirSupply) {
                    FabricGuiEventHelper.setGuiRightHeight(FabricGuiEventHelper.getGuiRightHeight() + 10);
                }
            }
        });
        RenderGuiLayerEvents.after(RenderGuiLayerEvents.VEHICLE_HEALTH).register(EventPhase.FIRST, (gui, guiGraphics, deltaTracker) -> {
            if (gui.field_2035.method_1560() instanceof class_1657) {
                class_1309 livingEntity = gui.method_1734();
                int maxHearts = gui.method_1744(livingEntity);
                FabricGuiEventHelper.setGuiRightHeight(FabricGuiEventHelper.getGuiRightHeight() + 10 * class_3532.method_15386((float)((float)maxHearts / 10.0f)));
            }
        });
    }
}

