/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.event;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.entity.living.AnimalTameCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ComputeEnchantedLootBonusCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.fabric.impl.event.CapturedDropsEntity;
import java.util.Collection;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public final class FabricEventImplHelper {
    private FabricEventImplHelper() {
    }

    public static int onAnimalTame(class_1429 animal, class_1657 player, int intValue) {
        return FabricEventImplHelper.onAnimalTame(animal, player, intValue, 1, intValue == 0);
    }

    public static int onAnimalTame(class_1429 animal, class_1657 player, int intValue, int returnValue, boolean tameCondition) {
        if (tameCondition && ((AnimalTameCallback)FabricLivingEvents.ANIMAL_TAME.invoker()).onAnimalTame(animal, player).isInterrupt()) {
            return returnValue;
        }
        return intValue;
    }

    public static float onLivingHurt(class_1309 livingEntity, class_3218 serverLevel, class_1282 damageSource, float damageAmount, MutableBoolean cancelInjection) {
        if (!livingEntity.method_5679(serverLevel, damageSource)) {
            DefaultedFloat damageAmountValue = DefaultedFloat.fromValue(damageAmount);
            EventResult result = ((LivingHurtCallback)FabricLivingEvents.LIVING_HURT.invoker()).onLivingHurt(livingEntity, damageSource, damageAmountValue);
            if (result.isInterrupt()) {
                cancelInjection.setTrue();
            }
            return damageAmountValue.getAsOptionalFloat().orElse(Float.valueOf(damageAmount)).floatValue();
        }
        return damageAmount;
    }

    public static int onComputeEnchantedLootBonus(class_6880<class_1887> enchantment, int enchantmentLevel, class_47 lootContext) {
        class_1297 entity = (class_1297)lootContext.method_65013(class_181.field_1226);
        if (!(entity instanceof class_1309)) {
            return enchantmentLevel;
        }
        class_1309 livingEntity = (class_1309)entity;
        class_1282 damageSource = (class_1282)lootContext.method_65013(class_181.field_1231);
        return FabricEventImplHelper.onComputeEnchantedLootBonus(enchantment, enchantmentLevel, livingEntity, damageSource);
    }

    public static int onComputeEnchantedLootBonus(class_6880<class_1887> enchantment, int enchantmentLevel, class_1309 livingEntity, @Nullable class_1282 damageSource) {
        MutableInt mutableInt = MutableInt.fromValue(enchantmentLevel);
        ((ComputeEnchantedLootBonusCallback)FabricLivingEvents.COMPUTE_ENCHANTED_LOOT_BONUS.invoker()).onComputeEnchantedLootBonus(livingEntity, damageSource, enchantment, mutableInt);
        return mutableInt.getAsInt();
    }

    public static boolean tryOnLivingDrops(class_1309 entity, class_1282 damageSource, int lastHurtByPlayerTime) {
        Collection<class_1542> capturedDrops = ((CapturedDropsEntity)entity).puzzleslib$acceptCapturedDrops(null);
        if (capturedDrops != null) {
            EventResult result = ((LivingDropsCallback)FabricLivingEvents.LIVING_DROPS.invoker()).onLivingDrops(entity, damageSource, capturedDrops, lastHurtByPlayerTime > 0);
            if (result.isPass()) {
                capturedDrops.forEach(itemEntity -> entity.method_37908().method_8649((class_1297)itemEntity));
            }
            return true;
        }
        return false;
    }
}

