/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1293;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public final class CreativeModeTabHelper {
    static final Collection<class_1792> POTION_ITEMS = ImmutableSet.of((Object)class_1802.field_8574, (Object)class_1802.field_8436, (Object)class_1802.field_8150, (Object)class_1802.field_8087);

    private CreativeModeTabHelper() {
    }

    public static class_2561 getTitle(class_2960 resourceLocation) {
        String translationKey = "itemGroup.%s.%s".formatted(resourceLocation.method_12836(), resourceLocation.method_12832());
        return class_2561.method_43471((String)translationKey);
    }

    public static class_1761.class_7914 getDisplayItems(String modId) {
        return CreativeModeTabHelper.getDisplayItems(modId, (Predicate<class_1799>)Predicates.alwaysTrue());
    }

    public static class_1761.class_7914 getDisplayItems(String modId, Predicate<class_1799> filter) {
        return (itemDisplayParameters, output) -> {
            Consumer<class_1799> itemStacks = itemStack -> {
                if (filter.test((class_1799)itemStack)) {
                    output.method_45420(itemStack);
                }
            };
            CreativeModeTabHelper.appendAllItems(modId, itemDisplayParameters.comp_1253(), itemStacks);
            CreativeModeTabHelper.appendAllEnchantments(modId, itemDisplayParameters.comp_1253(), itemStacks);
            CreativeModeTabHelper.appendAllPotions(modId, itemDisplayParameters.comp_1253(), itemStacks);
        };
    }

    public static void appendAllItems(String modId, class_7225.class_7874 registries, Consumer<class_1799> itemStacks) {
        CreativeModeTabHelper.getHoldersFromNamespace(class_7924.field_41197, registries, modId).map(class_1799::new).forEach(itemStacks);
    }

    public static void appendAllEnchantments(String modId, class_7225.class_7874 registries, Consumer<class_1799> itemStacks) {
        CreativeModeTabHelper.getHoldersFromNamespace(class_7924.field_41265, registries, modId).map(holder -> new class_1889((class_6880)holder, ((class_1887)holder.comp_349()).method_8183())).map(class_1890::method_61711).forEach(itemStacks);
    }

    public static void appendAllPotions(String modId, class_7225.class_7874 registries, Consumer<class_1799> itemStacks) {
        List<class_6880.class_6883> potions = CreativeModeTabHelper.getHoldersFromNamespace(class_7924.field_41215, registries, modId).filter(holder -> !((class_1842)holder.comp_349()).method_8049().isEmpty()).sorted(Comparator.comparing(holder -> (class_1293)((class_1842)holder.comp_349()).method_8049().getFirst())).toList();
        for (class_1792 item : POTION_ITEMS) {
            for (class_6880.class_6883 potion : potions) {
                itemStacks.accept(class_1844.method_57400((class_1792)item, (class_6880)potion));
            }
        }
    }

    public static <T> Stream<class_6880.class_6883<T>> getHoldersFromNamespace(class_5321<? extends class_2378<? extends T>> registryKey, class_7225.class_7874 registries, String modId) {
        return registries.method_46759(registryKey).stream().flatMap(class_7225::method_42017).filter(holder -> holder.method_40237().method_29177().method_12836().equals(modId));
    }
}

