/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.components;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;

public final class GuiGraphicsHelper {
    private GuiGraphicsHelper() {
    }

    public static void fillFrame(GuiGraphics guiGraphics, int posX, int posY, int width, int height, int borderSize, int color) {
        GuiGraphicsHelper.fillFrame(guiGraphics, posX, posY, width, height, borderSize, 0, color);
    }

    public static void fillFrame(GuiGraphics guiGraphics, int posX, int posY, int width, int height, int borderSize, int z, int color) {
        GuiGraphicsHelper.fillFrameArea(guiGraphics, posX, posY, posX + width, posY + height, borderSize, z, color);
    }

    public static void fillFrameArea(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY, int borderSize, int z, int color) {
        guiGraphics.m_280046_(minX, minY, maxX, minY + borderSize, z, color);
        guiGraphics.m_280046_(minX, maxY - borderSize, maxX, maxY, z, color);
        guiGraphics.m_280046_(minX, minY + borderSize, minX + borderSize, maxY - borderSize, z, color);
        guiGraphics.m_280046_(maxX - borderSize, minY + borderSize, maxX, maxY - borderSize, z, color);
    }

    public static void fillFrameArea(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY, int borderSize, int color) {
        GuiGraphicsHelper.fillFrameArea(guiGraphics, minX, minY, maxX, maxY, borderSize, 0, color);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int x, int y, int width, int height, int border, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, resourceLocation, x, y, width, height, border, border, border, border, spriteWidth, spriteHeight, uOffset, vOffset);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int x, int y, int width, int height, int left, int top, int right, int bottom, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
        SingleTextureAtlasSprite textureAtlasSprite = new SingleTextureAtlasSprite(resourceLocation, spriteWidth, spriteHeight, uOffset, vOffset);
        GuiSpriteScaling.NineSlice nineSlice = new GuiSpriteScaling.NineSlice(spriteWidth, spriteHeight, new GuiSpriteScaling.NineSlice.Border(left, top, right, bottom));
        guiGraphics.m_293720_((TextureAtlasSprite)textureAtlasSprite, nineSlice, x, y, 0, width, height);
    }

    public static void blitNineSliced(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int x, int y, int width, int height, int borderWidth, int borderHeight, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
        GuiGraphicsHelper.blitNineSliced(guiGraphics, resourceLocation, x, y, width, height, borderWidth, borderHeight, borderWidth, borderHeight, spriteWidth, spriteHeight, uOffset, vOffset);
    }

    private static class SingleTextureAtlasSprite
    extends TextureAtlasSprite {
        public SingleTextureAtlasSprite(ResourceLocation resourceLocation, int spriteWidth, int spriteHeight, int uOffset, int vOffset) {
            this(resourceLocation, spriteWidth, spriteHeight, uOffset, vOffset, 256, 256);
        }

        public SingleTextureAtlasSprite(ResourceLocation resourceLocation, int spriteWidth, int spriteHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
            super(resourceLocation, new SpriteContents(resourceLocation, new FrameSize(spriteWidth, spriteHeight), new NativeImage(textureWidth, textureHeight, false), ResourceMetadata.f_215577_), textureWidth, textureHeight, uOffset, vOffset);
        }
    }
}

