/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public final class ContainerSerializationHelper
extends ContainerHelper {
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_SLOT = "Slot";

    private ContainerSerializationHelper() {
    }

    public static CompoundTag saveAllItems(CompoundTag tag, NonNullList<ItemStack> items) {
        return ContainerHelper.m_18973_((CompoundTag)tag, items);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, Container container) {
        return ContainerSerializationHelper.saveAllItems(tag, container, true);
    }

    public static CompoundTag saveAllItems(String tagKey, CompoundTag tag, NonNullList<ItemStack> items) {
        return ContainerSerializationHelper.saveAllItems(tagKey, tag, items, true);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, Container container, boolean saveEmpty) {
        return ContainerSerializationHelper.saveAllItems(TAG_ITEMS, tag, container.m_6643_(), arg_0 -> ((Container)container).m_8020_(arg_0), saveEmpty);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, NonNullList<ItemStack> items, boolean saveEmpty) {
        return ContainerHelper.m_18976_((CompoundTag)tag, items, (boolean)saveEmpty);
    }

    public static CompoundTag saveAllItems(String tagKey, CompoundTag tag, NonNullList<ItemStack> items, boolean saveEmpty) {
        return ContainerSerializationHelper.saveAllItems(tagKey, tag, items.size(), arg_0 -> items.get(arg_0), saveEmpty);
    }

    public static CompoundTag saveAllItems(String tagKey, CompoundTag tag, int size, IntFunction<ItemStack> itemGetter, boolean saveEmpty) {
        ListTag listTag = ContainerSerializationHelper.createTag(size, itemGetter);
        if (!listTag.isEmpty() || saveEmpty) {
            tag.m_128365_(tagKey, (Tag)listTag);
        }
        return tag;
    }

    public static ListTag createTag(int size, IntFunction<ItemStack> itemGetter) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = itemGetter.apply(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128344_(TAG_SLOT, (byte)i);
            itemStack.m_41739_(compoundTag);
            listTag.add((Object)compoundTag);
        }
        return listTag;
    }

    public static void loadAllItems(CompoundTag tag, NonNullList<ItemStack> items) {
        ContainerHelper.m_18980_((CompoundTag)tag, items);
    }

    public static void loadAllItems(CompoundTag tag, Container container) {
        ContainerSerializationHelper.loadAllItems(TAG_ITEMS, tag, container.m_6643_(), (stack, value) -> container.m_6836_(value, stack));
    }

    public static void loadAllItems(String tagKey, CompoundTag tag, NonNullList<ItemStack> items) {
        ContainerSerializationHelper.loadAllItems(tagKey, tag, items.size(), (stack, value) -> items.set(value, stack));
    }

    public static void loadAllItems(String tagKey, CompoundTag tag, int size, ObjIntConsumer<ItemStack> itemSetter) {
        ListTag listTag = tag.m_128437_(tagKey, 10);
        ContainerSerializationHelper.fromTag(listTag, size, itemSetter);
    }

    public static void fromTag(ListTag listTag, int size, ObjIntConsumer<ItemStack> itemSetter) {
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            int slot = compoundTag.m_128445_(TAG_SLOT) & 0xFF;
            if (slot >= size) continue;
            itemSetter.accept(ItemStack.m_41712_((CompoundTag)compoundTag), slot);
        }
    }
}

