/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeProvider
extends RecipeProvider {
    protected final String modId;

    public AbstractRecipeProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractRecipeProvider(String modId, PackOutput packOutput) {
        super(packOutput);
        this.modId = modId;
    }

    @Nullable
    private static <T> JsonElement searchAndReplaceValue(@Nullable JsonElement jsonElement, T searchFor, T replaceWith) {
        block10: {
            block11: {
                Objects.requireNonNull(searchFor, "search for is null");
                Objects.requireNonNull(replaceWith, "replace with is null");
                if (jsonElement == null || jsonElement.isJsonNull()) break block10;
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                    if (jsonPrimitive.isNumber()) {
                        if (searchFor.equals(jsonPrimitive.getAsNumber())) {
                            return new JsonPrimitive((Number)replaceWith);
                        }
                    } else if (jsonPrimitive.isBoolean()) {
                        if (searchFor.equals(jsonPrimitive.getAsBoolean())) {
                            return new JsonPrimitive((Boolean)replaceWith);
                        }
                    } else if (jsonPrimitive.isString() && searchFor.toString().equals(jsonPrimitive.getAsString())) {
                        return new JsonPrimitive(replaceWith.toString());
                    }
                    return jsonElement;
                }
                if (!jsonElement.isJsonArray()) break block11;
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    jsonArray.set(i, AbstractRecipeProvider.searchAndReplaceValue(jsonArray.get(i), searchFor, replaceWith));
                }
                break block10;
            }
            if (!jsonElement.isJsonObject()) break block10;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                entry.setValue(AbstractRecipeProvider.searchAndReplaceValue((JsonElement)entry.getValue(), searchFor, replaceWith));
            }
        }
        return jsonElement;
    }

    public static String getHasName(ItemLike item, ItemLike ... items) {
        return "has_" + Stream.concat(Stream.of(item), Stream.of(items)).map(RecipeProvider::m_176632_).collect(Collectors.joining("_and_"));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike item, ItemLike ... items) {
        return AbstractRecipeProvider.m_293546_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_((ItemLike[])Stream.concat(Stream.of(item), Stream.of(items)).toArray(ItemLike[]::new)).m_45077_()});
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        ArrayList futures = new ArrayList();
        this.m_245200_(new IdentifiableRecipeOutput(output, futures));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public final void m_245200_(RecipeOutput recipeOutput) {
        this.addRecipes(recipeOutput);
    }

    public abstract void addRecipes(RecipeOutput var1);

    public class IdentifiableRecipeOutput
    implements RecipeOutput {
        private final CachedOutput output;
        private final List<CompletableFuture<?>> list;
        private final Set<ResourceLocation> set = Sets.newHashSet();

        public IdentifiableRecipeOutput(CachedOutput output, List<CompletableFuture<?>> list) {
            this.output = output;
            this.list = list;
        }

        public String getModId() {
            return AbstractRecipeProvider.this.modId;
        }

        public void m_292927_(ResourceLocation location, Recipe<?> recipe, @Nullable AdvancementHolder advancement) {
            ResourceLocation oldLocation = location;
            if (!this.set.add(location = new ResourceLocation(AbstractRecipeProvider.this.modId, location.m_135815_()))) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(location));
            }
            this.list.add(DataProvider.m_293028_((CachedOutput)this.output, (Codec)Recipe.f_302387_, recipe, (Path)AbstractRecipeProvider.this.f_236355_.m_245731_(location)));
            if (advancement != null) {
                JsonElement jsonElement = (JsonElement)Util.m_260975_((DataResult)Advancement.f_303179_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)advancement.f_290952_()), IllegalStateException::new);
                jsonElement = AbstractRecipeProvider.searchAndReplaceValue(jsonElement, oldLocation, location);
                ResourceLocation advancementLocation = new ResourceLocation(AbstractRecipeProvider.this.modId, advancement.f_291758_().m_135815_());
                this.list.add(DataProvider.m_253162_((CachedOutput)this.output, (JsonElement)jsonElement, (Path)AbstractRecipeProvider.this.f_236356_.m_245731_(advancementLocation)));
            }
        }

        public Advancement.Builder m_293552_() {
            return Advancement.Builder.m_285878_().m_138396_(RecipeBuilder.f_236353_);
        }
    }
}

