/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public final class RegistryHelper {
    private RegistryHelper() {
    }

    public static <T> Registry<T> findRegistry(ResourceKey<? extends Registry<? super T>> registryKey) {
        return RegistryHelper.findRegistry(registryKey, false);
    }

    public static <T> Registry<T> findBuiltInRegistry(ResourceKey<? extends Registry<? super T>> registryKey) {
        return RegistryHelper.findRegistry(registryKey, true);
    }

    private static <T> Registry<T> findRegistry(ResourceKey<? extends Registry<? super T>> registryKey, boolean onlyBuiltIn) {
        MinecraftServer minecraftServer;
        Objects.requireNonNull(registryKey, "registry key is null");
        Optional registry = Optional.empty();
        if (!onlyBuiltIn && (minecraftServer = CommonAbstractions.INSTANCE.getMinecraftServer()) != null) {
            registry = minecraftServer.m_206579_().m_6632_(registryKey);
        }
        if (registry.isEmpty()) {
            registry = BuiltInRegistries.f_257047_.m_123009_(registryKey);
        }
        return (Registry)registry.orElseThrow(() -> new IllegalArgumentException("Registry for key %s not found".formatted(registryKey)));
    }

    public static <T> Optional<ResourceKey<T>> getResourceKey(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return RegistryHelper.getHolder(registryKey, object).map(Holder.Reference::m_205785_);
    }

    public static <T> ResourceKey<T> getResourceKeyOrThrow(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return RegistryHelper.getResourceKey(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registryKey) + ": " + String.valueOf(object)));
    }

    public static <T> Optional<Holder.Reference<T>> getHolder(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return Optional.ofNullable(RegistryHelper.getBuiltInRegistryHolder(object)).or(() -> {
            Registry registry = RegistryHelper.findRegistry(registryKey);
            return registry.m_7854_(object).flatMap(arg_0 -> registry.m_203636_(arg_0));
        });
    }

    public static <T> Holder.Reference<T> getHolderOrThrow(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return RegistryHelper.getHolder(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registryKey) + ": " + String.valueOf(object)));
    }

    public static <T> Holder<T> wrapAsHolder(ResourceKey<? extends Registry<? super T>> registryKey, T object) {
        return RegistryHelper.findRegistry(registryKey).m_263177_(object);
    }

    public static <T> boolean is(TagKey<T> tagKey, T object) {
        Holder.Reference<T> holder = RegistryHelper.getBuiltInRegistryHolder(object);
        if (holder != null) {
            return holder.m_203656_(tagKey);
        }
        Registry<T> registry = RegistryHelper.findRegistry(tagKey.f_203867_());
        return tagKey.m_207645_(registry.m_123023_()) && registry.m_263177_(object).m_203656_(tagKey);
    }

    @Nullable
    public static <T> Holder.Reference<T> getBuiltInRegistryHolder(T object) {
        Holder.Reference holder = null;
        if (object instanceof Block) {
            Block block = (Block)object;
            holder = block.m_204297_();
        } else if (object instanceof Item) {
            Item item = (Item)object;
            holder = item.m_204114_();
        } else if (object instanceof EntityType) {
            EntityType entityType = (EntityType)object;
            holder = entityType.m_204041_();
        } else if (object instanceof GameEvent) {
            GameEvent gameEvent = (GameEvent)object;
            holder = gameEvent.m_204530_();
        } else if (object instanceof Fluid) {
            Fluid fluid = (Fluid)object;
            holder = fluid.m_205069_();
        } else if (object instanceof Enchantment) {
            Enchantment enchantment = (Enchantment)object;
            holder = enchantment.m_292589_();
        } else if (object instanceof MobEffect) {
            MobEffect mobEffect = (MobEffect)object;
            holder = mobEffect.m_295099_();
        } else if (object instanceof Potion) {
            Potion potion = (Potion)object;
            holder = potion.m_293993_();
        } else if (object instanceof BlockEntityType) {
            BlockEntityType blockEntityType = (BlockEntityType)object;
            holder = blockEntityType.m_294149_();
        }
        return holder;
    }
}

