/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v2;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandlerV2 {
    public static NetworkHandlerV2 build(String modId, boolean optional) {
        return NetworkHandlerV2.build(new ResourceLocation(modId, "main"), optional);
    }

    public static NetworkHandlerV2 build(ResourceLocation channelName, boolean optional) {
        return ModContext.get(channelName.m_135827_()).getNetworkHandlerV2(channelName, optional);
    }

    default public <T extends MessageV2<T>> NetworkHandlerV2 registerClientbound(Class<T> clazz, Supplier<T> factory) {
        return this.registerClientbound(clazz, (FriendlyByteBuf friendlyByteBuf) -> {
            MessageV2 message = (MessageV2)factory.get();
            message.read((FriendlyByteBuf)friendlyByteBuf);
            return message;
        });
    }

    default public <T extends MessageV2<T>> NetworkHandlerV2 registerServerbound(Class<T> clazz, Supplier<T> factory) {
        return this.registerServerbound(clazz, (FriendlyByteBuf friendlyByteBuf) -> {
            MessageV2 message = (MessageV2)factory.get();
            message.read((FriendlyByteBuf)friendlyByteBuf);
            return message;
        });
    }

    public <T extends MessageV2<T>> NetworkHandlerV2 registerClientbound(Class<T> var1, Function<FriendlyByteBuf, T> var2);

    public <T extends MessageV2<T>> NetworkHandlerV2 registerServerbound(Class<T> var1, Function<FriendlyByteBuf, T> var2);

    public Packet<ClientCommonPacketListener> toClientboundPacket(MessageV2<?> var1);

    public Packet<ServerCommonPacketListener> toServerboundPacket(MessageV2<?> var1);

    default public void sendToServer(MessageV2<?> message) {
        Proxy.INSTANCE.getClientPacketListener().m_295327_(this.toServerboundPacket(message));
    }

    default public void sendTo(MessageV2<?> message, ServerPlayer player) {
        player.f_8906_.m_141995_(this.toClientboundPacket(message));
    }

    default public void sendToAll(MessageV2<?> message) {
        CommonAbstractions.INSTANCE.getMinecraftServer().m_6846_().m_11268_(this.toClientboundPacket(message));
    }

    default public void sendToAllExcept(MessageV2<?> message, ServerPlayer exclude) {
        for (ServerPlayer player : CommonAbstractions.INSTANCE.getMinecraftServer().m_6846_().m_11314_()) {
            if (player == exclude) continue;
            this.sendTo(message, player);
        }
    }

    default public void sendToAllNear(MessageV2<?> message, BlockPos pos, Level level) {
        this.sendToAllNearExcept(message, null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 64.0, level);
    }

    default public void sendToAllNear(MessageV2<?> message, double posX, double posY, double posZ, double distance, Level level) {
        this.sendToAllNearExcept(message, null, posX, posY, posZ, 64.0, level);
    }

    default public void sendToAllNearExcept(MessageV2<?> message, @Nullable ServerPlayer exclude, double posX, double posY, double posZ, double distance, Level level) {
        CommonAbstractions.INSTANCE.getMinecraftServer().m_6846_().m_11241_((Player)exclude, posX, posY, posZ, distance, level.m_46472_(), this.toClientboundPacket(message));
    }

    default public void sendToAllTracking(MessageV2<?> message, Entity entity) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8445_(entity, this.toClientboundPacket(message));
    }

    default public void sendToAllTrackingAndSelf(MessageV2<?> message, Entity entity) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8394_(entity, this.toClientboundPacket(message));
    }

    default public void sendToDimension(MessageV2<?> message, Level level) {
        this.sendToDimension(message, (ResourceKey<Level>)level.m_46472_());
    }

    default public void sendToDimension(MessageV2<?> message, ResourceKey<Level> dimension) {
        CommonAbstractions.INSTANCE.getMinecraftServer().m_6846_().m_11270_(this.toClientboundPacket(message), dimension);
    }
}

