/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.chat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Unit;
import org.jetbrains.annotations.Nullable;

public class FormattedContentSink
implements FormattedText.StyledContentConsumer<Unit>,
FormattedCharSink {
    private final List<Map.Entry<StringBuilder, Style>> builders = Lists.newArrayList((Object[])new Map.Entry[]{Map.entry(new StringBuilder(), Style.f_131099_)});
    @Nullable
    private Component component;
    @Nullable
    private String string;

    public FormattedContentSink(FormattedText formattedText) {
        formattedText.m_7451_((FormattedText.StyledContentConsumer)this, Style.f_131099_);
        if (formattedText instanceof Component) {
            this.component = ((Component)formattedText).m_6881_();
        }
    }

    public FormattedContentSink(FormattedCharSequence formattedCharSequence) {
        formattedCharSequence.m_13731_((FormattedCharSink)this);
    }

    public Optional<Unit> m_7164_(Style style, String string) {
        Map.Entry<StringBuilder, Style> entry = this.builders.get(this.builders.size() - 1);
        if (entry.getValue() == style || entry.getValue().m_131179_() && style.m_131179_()) {
            entry.getKey().append(string);
        } else {
            this.builders.add(Map.entry(new StringBuilder(string), style));
        }
        return Optional.empty();
    }

    public boolean m_6411_(int width, Style style, int codePoint) {
        this.m_7164_(style, String.valueOf(Character.toChars(codePoint)));
        return true;
    }

    public Component getComponent() {
        if (this.component == null) {
            MutableComponent component = null;
            for (Map.Entry<StringBuilder, Style> entry : this.builders) {
                MutableComponent componentFromEntry = Component.m_237113_((String)entry.getKey().toString()).m_6270_(entry.getValue());
                if (component == null) {
                    component = componentFromEntry;
                    continue;
                }
                component.m_7220_((Component)componentFromEntry);
            }
            Objects.requireNonNull(component, "component is null");
            this.component = component;
        }
        return this.component;
    }

    public String getString() {
        if (this.string == null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<StringBuilder, Style> entry : this.builders) {
                builder.append(this.getStringFormatFromStyle(entry.getValue()));
                builder.append((CharSequence)entry.getKey());
                builder.append(ChatFormatting.RESET);
            }
            this.string = builder.toString();
        }
        return this.string;
    }

    public String getStringFormatFromStyle(Style style) {
        if (style.m_131179_()) {
            return "";
        }
        return this.getFormatFromStyle(style).stream().map(ChatFormatting::toString).collect(Collectors.joining());
    }

    public List<ChatFormatting> getFormatFromStyle(Style style) {
        ChatFormatting color;
        ArrayList<ChatFormatting> list = new ArrayList<ChatFormatting>();
        if (style.m_131135_() != null && (color = ChatFormatting.m_126657_((String)style.m_131135_().m_131274_())) != null) {
            list.add(color);
        }
        if (style.m_131176_()) {
            list.add(ChatFormatting.OBFUSCATED);
        }
        if (style.m_131154_()) {
            list.add(ChatFormatting.BOLD);
        }
        if (style.m_131168_()) {
            list.add(ChatFormatting.STRIKETHROUGH);
        }
        if (style.m_131171_()) {
            list.add(ChatFormatting.UNDERLINE);
        }
        if (style.m_131161_()) {
            list.add(ChatFormatting.ITALIC);
        }
        return list;
    }
}

