/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenOpeningCallback;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;

public class PuzzlesLibClient
implements ClientModConstructor {
    @Override
    public void onConstructMod() {
        PuzzlesLibClient.setupDevelopmentEnvironment();
    }

    private static void setupDevelopmentEnvironment() {
        if (!ModLoaderEnvironment.INSTANCE.isDevelopmentEnvironment() || ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isForgeLike()) {
            PuzzlesLibClient.setupGameOptions();
        }
        PuzzlesLibClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ScreenOpeningCallback.EVENT.register((oldScreen, newScreen) -> {
            Object patt1831$temp = newScreen.get();
            if (patt1831$temp instanceof CreateWorldScreen) {
                CreateWorldScreen screen = (CreateWorldScreen)patt1831$temp;
                screen.m_267748_().m_267616_(WorldCreationUiState.SelectedGameMode.CREATIVE);
                screen.m_267748_().m_267601_(true);
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseClick(Screen.class).register((screen, mouseX, mouseY, button) -> {
            for (GuiEventListener guiEventListener : screen.m_6702_()) {
                if (!(guiEventListener instanceof EditBox) || !guiEventListener.m_6375_(mouseX, mouseY, button)) continue;
                screen.m_7522_(guiEventListener);
                if (button == 0) {
                    screen.m_7897_(true);
                }
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseRelease(Screen.class).register((screen, mouseX, mouseY, button) -> {
            screen.m_7897_(false);
            return screen.m_94729_(mouseX, mouseY).filter(EditBox.class::isInstance).filter(guiEventListener -> guiEventListener.m_6348_(mouseX, mouseY, button)).isPresent() ? EventResult.INTERRUPT : EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseDrag(Screen.class).register((screen, mouseX, mouseY, button, dragX, dragY) -> screen.m_7222_() instanceof EditBox && screen.m_7282_() && button == 0 && screen.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY) ? EventResult.INTERRUPT : EventResult.PASS);
    }

    private static void setupGameOptions() {
        Minecraft minecraft = Minecraft.m_91087_();
        boolean running = minecraft.f_91019_;
        minecraft.f_91019_ = false;
        PuzzlesLibClient.initializeGameOptions(minecraft.f_91066_);
        minecraft.f_91019_ = running;
    }

    public static void initializeGameOptions(Options options) {
        if (options.m_168450_().exists()) {
            return;
        }
        options.m_231984_().m_231514_((Object)16);
        options.m_232035_().m_231514_((Object)60);
        options.m_292959_().m_231514_((Object)false);
        options.f_92125_ = true;
        options.f_92030_ = TutorialSteps.NONE;
        options.f_92031_ = true;
        options.f_168405_ = true;
        options.m_257871_().m_231514_((Object)true);
        options.m_231818_().m_231514_((Object)false);
        options.m_231822_().m_231514_((Object)false);
        options.m_231825_().m_231514_((Object)true);
        options.m_231928_().m_231514_((Object)5);
        options.f_263744_ = false;
        options.f_92083_ = true;
    }

    @Override
    public void onClientSetup() {
        if (!ModLoaderEnvironment.INSTANCE.isDevelopmentEnvironment() || ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        CreativeModeInventoryScreen.f_98507_ = (CreativeModeTab)BuiltInRegistries.f_279662_.m_123013_(CreativeModeTabs.f_256750_);
    }
}

