/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.impl.item.CopyTagShapedRecipe;
import fuzs.puzzleslib.impl.item.CopyTagShapelessRecipe;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public interface CopyTagRecipe {
    public static final String SHAPED_RECIPE_SERIALIZER_ID = "copy_tag_shaped_recipe";
    public static final String SHAPELESS_RECIPE_SERIALIZER_ID = "copy_tag_shapeless_recipe";

    public static RecipeSerializer<?> getModSerializer(String modId, String recipeSerializerId) {
        RecipeSerializer recipeSerializer = (RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(new ResourceLocation(modId, recipeSerializerId));
        if (recipeSerializer == null) {
            ContentRegistrationFlags.throwForFlag(ContentRegistrationFlags.COPY_TAG_RECIPES);
        }
        return recipeSerializer;
    }

    public static void registerSerializers(BiConsumer<String, Supplier<RecipeSerializer<?>>> registrar) {
        registrar.accept(SHAPED_RECIPE_SERIALIZER_ID, () -> new Serializer<ShapedRecipe, CopyTagShapedRecipe>((RecipeSerializer<ShapedRecipe>)new ShapedRecipe.Serializer(), CopyTagShapedRecipe::new));
        registrar.accept(SHAPELESS_RECIPE_SERIALIZER_ID, () -> new Serializer<ShapelessRecipe, CopyTagShapelessRecipe>((RecipeSerializer<ShapelessRecipe>)new ShapelessRecipe.Serializer(), CopyTagShapelessRecipe::new));
    }

    public Ingredient getCopyTagSource();

    default public void tryCopyTagToResult(ItemStack result, CraftingContainer craftingContainer) {
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemStack = craftingContainer.m_8020_(i);
            if (!this.getCopyTagSource().test(itemStack) || !itemStack.m_41782_()) continue;
            result.m_41751_(itemStack.m_41783_().m_6426_());
            return;
        }
    }

    public record Serializer<T extends CraftingRecipe, S extends CraftingRecipe & CopyTagRecipe>(RecipeSerializer<T> serializer, Factory<T, S> factory) implements RecipeSerializer<S>
    {
        public Codec<S> m_292673_() {
            return RecordCodecBuilder.create(instance -> instance.group((App)((MapCodec.MapCodecCodec)this.serializer.m_292673_()).codec().forGetter(arg -> arg), (App)Ingredient.f_291570_.fieldOf("copy_from").forGetter(arg -> ((CopyTagRecipe)arg).getCopyTagSource())).apply((Applicative)instance, (craftingRecipe, ingredient) -> this.factory.apply(this, (CraftingRecipe)craftingRecipe, (Ingredient)ingredient)));
        }

        public S fromNetwork(FriendlyByteBuf buffer) {
            CraftingRecipe recipe = (CraftingRecipe)this.serializer.m_8005_(buffer);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return this.factory.apply(this, recipe, ingredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, S recipe) {
            this.serializer.m_6178_(buffer, recipe);
            ((CopyTagRecipe)recipe).getCopyTagSource().m_43923_(buffer);
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends CraftingRecipe, S extends CraftingRecipe & CopyTagRecipe> {
        public S apply(RecipeSerializer<?> var1, T var2, Ingredient var3);
    }
}

