/*
 * Decompiled with CFR 0.152.
 */
package com.lumyverse.lumymon.block.entity.custom;

import com.lumyverse.lumymon.LumyMon;
import com.lumyverse.lumymon.block.entity.ImplementedInventory;
import com.lumyverse.lumymon.block.entity.ModBlockEntities;
import com.lumyverse.lumymon.recipe.MapStructureRecipe;
import com.lumyverse.lumymon.recipe.MapTraderRecipe;
import com.lumyverse.lumymon.recipe.MapTraderRecipeInput;
import com.lumyverse.lumymon.recipe.ModRecipes;
import com.lumyverse.lumymon.screen.custom.MapTraderScreenHandler;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class MapTraderEntity
extends class_2586
implements ImplementedInventory,
ExtendedScreenHandlerFactory<class_2338> {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> MapTraderEntity.this.progress;
                case 1 -> MapTraderEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    MapTraderEntity.this.progress = value;
                    break;
                }
                case 1: {
                    MapTraderEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 128;
    private boolean hasSentNotFoundMessage = false;

    public class_3913 getPropertyDelegate() {
        return this.propertyDelegate;
    }

    public MapTraderEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.MAPTRADER_BE, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        class_1799 oldStack = (class_1799)this.inventory.get(slot);
        this.getItems().set(slot, (Object)stack);
        if (stack.method_7947() > stack.method_7909().method_7882()) {
            stack.method_7939(stack.method_7909().method_7882());
        }
        if (slot == 0 && !class_1799.method_7973((class_1799)oldStack, (class_1799)stack)) {
            this.hasSentNotFoundMessage = false;
        }
        this.method_5431();
    }

    @Override
    public void method_5431() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
        super.method_5431();
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("maptrader.progress", this.progress);
        nbt.method_10569("maptrader.max_progress", this.maxProgress);
        nbt.method_10556("maptrader.has_sent_not_found_message", this.hasSentNotFoundMessage);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        this.progress = nbt.method_10550("maptrader.progress");
        this.maxProgress = nbt.method_10550("maptrader.max_progress");
        this.hasSentNotFoundMessage = nbt.method_10577("maptrader.has_sent_not_found_message");
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.lumymon.map_trader");
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, MapTraderEntity entity) {
        if (world.method_8608()) {
            return;
        }
        class_1277 tempInputInventory = new class_1277(new class_1799[]{entity.method_5438(0)});
        Optional structureRecipe = world.method_8433().method_8132(ModRecipes.MAP_STRUCTURE_TYPE, (class_9695)new MapTraderRecipeInput((class_1263)tempInputInventory, world), world);
        if (structureRecipe.isPresent()) {
            if (entity.canCraftMap((class_8786<MapStructureRecipe>)((class_8786)structureRecipe.get()))) {
                entity.increaseCraftingProgress();
                MapTraderEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (entity.hasCraftingFinished()) {
                    entity.craftMap((class_8786<MapStructureRecipe>)((class_8786)structureRecipe.get()));
                    entity.resetProgress();
                    if (entity.hasSentNotFoundMessage) {
                        entity.hasSentNotFoundMessage = false;
                    }
                    MapTraderEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                }
            } else if (entity.progress > 0) {
                entity.resetProgress();
                MapTraderEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            }
        } else {
            Optional genericRecipe = world.method_8433().method_8132(ModRecipes.MAP_TRADER_TYPE, (class_9695)new MapTraderRecipeInput((class_1263)tempInputInventory, world), world);
            if (genericRecipe.isPresent()) {
                if (entity.canCraftGeneric((class_8786<MapTraderRecipe>)((class_8786)genericRecipe.get()))) {
                    entity.increaseCraftingProgress();
                    MapTraderEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                    if (entity.hasCraftingFinished()) {
                        entity.craftGenericItem((class_8786<MapTraderRecipe>)((class_8786)genericRecipe.get()));
                        entity.resetProgress();
                        if (entity.hasSentNotFoundMessage) {
                            entity.hasSentNotFoundMessage = false;
                        }
                        MapTraderEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                    }
                } else if (entity.progress > 0) {
                    entity.resetProgress();
                    MapTraderEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                }
            } else {
                if (entity.progress > 0) {
                    entity.resetProgress();
                    MapTraderEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                }
                if (entity.hasSentNotFoundMessage) {
                    entity.hasSentNotFoundMessage = false;
                    MapTraderEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                }
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 128;
    }

    private void craftMap(class_8786<MapStructureRecipe> recipeEntry) {
        class_6862 structureTagKey;
        if (!this.canCraftMap(recipeEntry)) {
            LumyMon.LOGGER.warn("MapTraderEntity: Attempted to craft map but canCraftMap returned false. This should not happen.");
            return;
        }
        MapStructureRecipe currentRecipe = (MapStructureRecipe)recipeEntry.comp_1933();
        class_3218 serverWorld = (class_3218)this.field_11863;
        if (currentRecipe.structureIdentifier().method_12832().startsWith("#")) {
            class_2960 tagIdentifier = class_2960.method_60655((String)currentRecipe.structureIdentifier().method_12836(), (String)currentRecipe.structureIdentifier().method_12832().substring(1));
            structureTagKey = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)tagIdentifier);
            LumyMon.LOGGER.info("Attempting to locate structure by TagKey (from #tag): {}", (Object)structureTagKey.comp_327());
        } else {
            structureTagKey = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)currentRecipe.structureIdentifier());
            LumyMon.LOGGER.warn("Attempting to locate structure by direct Identifier '{}' using TagKey workaround. Ensure this structure is part of a tag, or add a specific tag for it.", (Object)currentRecipe.structureIdentifier());
        }
        class_2338 foundStructurePos = serverWorld.method_8487(structureTagKey, this.field_11867, currentRecipe.discoveryRange(), false);
        if (foundStructurePos != null) {
            class_3218 serverWorldInstance2;
            class_3222 nearestPlayer;
            LumyMon.LOGGER.info("MapTraderEntity: Found structure at {}", (Object)foundStructurePos);
            class_1799 mapStack = class_1806.method_8005((class_1937)serverWorld, (int)foundStructurePos.method_10263(), (int)foundStructurePos.method_10260(), (byte)2, (boolean)true, (boolean)true);
            class_1806.method_8002((class_3218)serverWorld, (class_1799)mapStack);
            mapStack.method_57379(class_9334.field_49631, (Object)currentRecipe.mapName());
            class_22.method_110((class_1799)mapStack, (class_2338)foundStructurePos, (String)"+", (class_6880)class_21.field_85);
            this.method_5434(0, 1);
            this.method_5447(1, mapStack);
            LumyMon.LOGGER.info("MapTraderEntity: Successfully crafted map.");
            this.hasSentNotFoundMessage = false;
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218 && (nearestPlayer = (class_3222)(serverWorldInstance2 = (class_3218)class_19372).method_18459((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), 10.0, false)) != null) {
                double distance = class_243.method_24953((class_2382)this.field_11867).method_1022(class_243.method_24953((class_2382)foundStructurePos));
                nearestPlayer.method_7353((class_2561)class_2561.method_43469((String)"message.lumymon.structure_found", (Object[])new Object[]{(int)Math.round(distance)}), false);
            }
        } else {
            class_3218 serverWorldInstance;
            class_3222 nearestPlayer;
            class_1937 serverWorldInstance2;
            LumyMon.LOGGER.info("MapTraderEntity: Could not find structure '{}' near {} within range {}. Input retained, sending message to player.", new Object[]{currentRecipe.structureIdentifier().toString(), this.field_11867.method_23854(), currentRecipe.discoveryRange()});
            if (!this.hasSentNotFoundMessage && (serverWorldInstance2 = this.field_11863) instanceof class_3218 && (nearestPlayer = (class_3222)(serverWorldInstance = (class_3218)serverWorldInstance2).method_18459((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), 10.0, false)) != null) {
                nearestPlayer.method_7353((class_2561)class_2561.method_43469((String)"message.lumymon.structure_not_found", (Object[])new Object[]{currentRecipe.discoveryRange()}), false);
                nearestPlayer.method_7353((class_2561)class_2561.method_43471((String)"message.lumymon.structure_not_found.tip"), false);
                this.hasSentNotFoundMessage = true;
                this.method_5431();
            }
        }
    }

    private void craftGenericItem(class_8786<MapTraderRecipe> recipeEntry) {
        if (!this.canCraftGeneric(recipeEntry)) {
            LumyMon.LOGGER.warn("MapTraderEntity: Attempted to craft generic item but canCraftGeneric returned false. This should not happen.");
            return;
        }
        class_1799 output = ((MapTraderRecipe)recipeEntry.comp_1933()).output();
        this.method_5434(0, 1);
        this.method_5447(1, new class_1799((class_1935)output.method_7909(), this.method_5438(1).method_7947() + output.method_7947()));
        LumyMon.LOGGER.info("MapTraderEntity: Successfully crafted generic item.");
        this.hasSentNotFoundMessage = false;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean canCraftMap(class_8786<MapStructureRecipe> recipeEntry) {
        class_1799 inputStack = this.method_5438(0);
        class_1799 outputStack = this.method_5438(1);
        MapStructureRecipe recipe = (MapStructureRecipe)recipeEntry.comp_1933();
        return recipe.input().method_8093(inputStack) && (outputStack.method_7960() || outputStack.method_7909() == class_1802.field_8204);
    }

    private boolean canCraftGeneric(class_8786<MapTraderRecipe> recipeEntry) {
        class_1799 inputStack = this.method_5438(0);
        class_1799 outputStack = this.method_5438(1);
        MapTraderRecipe recipe = (MapTraderRecipe)recipeEntry.comp_1933();
        return recipe.inputItem().method_8093(inputStack) && this.canInsertItemIntoOutputSlot(recipe.output()) && this.canInsertAmountIntoOutputSlot(recipe.output().method_7947());
    }

    private Optional<class_8786<MapStructureRecipe>> getCurrentStructureRecipe() {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        class_1277 currentInputInventory = new class_1277(new class_1799[]{(class_1799)this.inventory.get(0)});
        return this.field_11863.method_8433().method_8132(ModRecipes.MAP_STRUCTURE_TYPE, (class_9695)new MapTraderRecipeInput((class_1263)currentInputInventory, this.field_11863), this.field_11863);
    }

    private Optional<class_8786<MapTraderRecipe>> getCurrentItemRecipe() {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        class_1277 currentInputInventory = new class_1277(new class_1799[]{(class_1799)this.inventory.get(0)});
        return this.field_11863.method_8433().method_8132(ModRecipes.MAP_TRADER_TYPE, (class_9695)new MapTraderRecipeInput((class_1263)currentInputInventory, this.field_11863), this.field_11863);
    }

    private boolean canInsertItemIntoOutputSlot(class_1799 output) {
        return this.method_5438(1).method_7960() || this.method_5438(1).method_7909() == output.method_7909();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.method_5438(1).method_7960() ? 64 : this.method_5438(1).method_7909().method_7882();
        int currentCount = this.method_5438(1).method_7947();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new MapTraderScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    @Override
    public void onBroken(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!world.method_8608()) {
            class_1264.method_17349((class_1937)world, (class_2338)pos, this.inventory);
        }
    }
}

