/*
 * Decompiled with CFR 0.152.
 */
package com.lumyverse.lumymon;

import com.lumyverse.lumymon.block.ModBlocks;
import com.lumyverse.lumymon.block.entity.ModBlockEntities;
import com.lumyverse.lumymon.item.ModItemGroups;
import com.lumyverse.lumymon.item.ModItems;
import com.lumyverse.lumymon.recipe.ModRecipes;
import com.lumyverse.lumymon.screen.ModScreenHandlers;
import com.lumyverse.lumymon.sound.ModSounds;
import com.lumyverse.lumymon.util.SummonScheduler;
import com.lumyverse.lumymon.villager.ModVillagers;
import com.lumyverse.lumymon.world.gen.ModWorldGeneration;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LumyMon
implements ModInitializer {
    public static final String MOD_ID = "lumymon";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"lumymon");

    public void onInitialize() {
        ModItemGroups.registerItemGroups();
        ModItems.registerModItems();
        ModBlocks.registerModBlocks();
        ModVillagers.registerVillagers();
        ModBlockEntities.registerBlockEntities();
        ModScreenHandlers.registerScreenHandlers();
        ModRecipes.registerModRecipes();
        ModSounds.registerModSounds();
        ModWorldGeneration.generateModWorldGen();
        SummonScheduler.register();
        Object modVersion = "";
        Optional modContainer = FabricLoader.getInstance().getModContainer(MOD_ID);
        if (modContainer.isPresent()) {
            String fullVersion = ((ModContainer)modContainer.get()).getMetadata().getVersion().getFriendlyString();
            String[] versionParts = fullVersion.split("\\.");
            modVersion = versionParts.length > 3 ? versionParts[0] + "." + versionParts[1] + "." + versionParts[2] : fullVersion;
        }
        LOGGER.info("LumyMon v{} - Made by LUMYVERSE", modVersion);
    }
}

