/*
 * Decompiled with CFR 0.152.
 */
package com.lumyverse.lumymon;

import com.lumyverse.lumymon.block.ModBlocks;
import com.lumyverse.lumymon.screen.ModScreenHandlers;
import com.lumyverse.lumymon.screen.custom.MapTraderScreen;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LumyMonClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LumyMon");
    private static final long MAX_EMPTY_SERVERS_DAT_SIZE_BYTES = 10L;

    public void onInitializeClient() {
        LOGGER.info("LumyMon: Inizializzazione del controllo servers.dat...");
        this.checkAndReplaceServersDat();
        class_3929.method_17542(ModScreenHandlers.MAP_TRADER_SCREEN_HANDLER, MapTraderScreen::new);
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.ICEROOT_CARROT_CROP, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.SHADEROOT_CARROT_CROP, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.CALYREX_STATUE, class_1921.method_23581());
    }

    private void checkAndReplaceServersDat() {
        Path gameDirectory = class_310.method_1551().field_1697.toPath();
        Path playerServersDatPath = gameDirectory.resolve("servers.dat");
        Path defaultServersDatPath = gameDirectory.resolve("config").resolve("defaultoptions").resolve("servers.dat");
        LOGGER.info("LumyMon: Percorso servers.dat giocatore: {}", (Object)playerServersDatPath);
        LOGGER.info("LumyMon: Percorso servers.dat predefinito: {}", (Object)defaultServersDatPath);
        if (!Files.exists(defaultServersDatPath, new LinkOption[0])) {
            LOGGER.warn("LumyMon: Il file servers.dat predefinito non \u00e8 stato trovato in {}. Salto la sostituzione.", (Object)defaultServersDatPath);
            return;
        }
        if (!Files.exists(playerServersDatPath, new LinkOption[0])) {
            LOGGER.info("LumyMon: Il servers.dat del giocatore non esiste. Copio il file servers.dat predefinito.");
            try {
                Files.copy(defaultServersDatPath, playerServersDatPath, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("LumyMon: Copia del servers.dat predefinito completata con successo.");
            }
            catch (IOException e) {
                LOGGER.error("LumyMon: Errore durante la copia del servers.dat predefinito: {}", (Object)e.getMessage());
            }
            return;
        }
        try {
            long playerServersDatSize = Files.size(playerServersDatPath);
            LOGGER.info("LumyMon: Dimensione del servers.dat del giocatore rilevata: {} bytes. Soglia massima per il file vuoto: {} bytes.", (Object)playerServersDatSize, (Object)10L);
            if (playerServersDatSize <= 10L) {
                LOGGER.info("LumyMon: Rilevato servers.dat con dimensione fino a {} byte (considerato vuoto). Copio il file servers.dat predefinito.", (Object)10L);
                try {
                    Files.copy(defaultServersDatPath, playerServersDatPath, StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.info("LumyMon: Copia del servers.dat predefinito completata.");
                }
                catch (IOException e) {
                    LOGGER.error("LumyMon: Impossibile effettuare la copia del servers.dat predefinito: {}", (Object)e.getMessage());
                }
            } else {
                LOGGER.info("LumyMon: Il servers.dat del giocatore esiste e ha dimensione maggiore di {} byte. Salto la sostituzione.", (Object)10L);
            }
        }
        catch (IOException e) {
            LOGGER.error("LumyMon: Errore durante il recupero della dimensione del servers.dat del giocatore: {}", (Object)e.getMessage());
        }
    }
}

