/*
 * Decompiled with CFR 0.152.
 */
package com.lumyverse.lumymon.block.custom;

import com.lumyverse.lumymon.LumyMon;
import com.lumyverse.lumymon.block.ModBlocks;
import com.lumyverse.lumymon.item.ModItems;
import com.lumyverse.lumymon.sound.ModSounds;
import com.lumyverse.lumymon.util.SummonScheduler;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.MapCodec;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import net.minecraft.server.MinecraftServer;

public class JirachiShrine
extends class_2383 {
    public static final class_2753 FACING = class_2741.field_12481;
    private static final ConcurrentHashMap<UUID, Long> LAST_ERROR_MESSAGE_TIME = new ConcurrentHashMap();
    private static final long MESSAGE_COOLDOWN_MS = 30000L;
    public static final MapCodec<JirachiShrine> CODEC = JirachiShrine.method_54094(JirachiShrine::new);

    public JirachiShrine(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042());
    }

    public class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 user, class_1268 hand, class_3965 hit) {
        if (world.method_8608()) {
            if (stack.method_7960() || stack.method_7909() == ModItems.MELODIC_TAPE_VOL_1) {
                return class_9062.field_47728;
            }
            return class_9062.field_47733;
        }
        Random random = new Random();
        int randomNumber = random.nextInt(100) + 1;
        if (stack.method_7909() == ModItems.MELODIC_TAPE_VOL_1) {
            class_2338 summonAnchorPos = null;
            int searchRadiusXZ = 15;
            int searchHeightUp = 15;
            int searchHeightDown = 5;
            for (int yOffset = -searchHeightDown; yOffset <= searchHeightUp; ++yOffset) {
                for (int xOffset = -searchRadiusXZ; xOffset <= searchRadiusXZ; ++xOffset) {
                    for (int zOffset = -searchRadiusXZ; zOffset <= searchRadiusXZ; ++zOffset) {
                        class_2338 currentCheckPos = pos.method_10069(xOffset, yOffset, zOffset);
                        if (!world.method_8320(currentCheckPos).method_27852(ModBlocks.SUMMON_ANCHOR)) continue;
                        summonAnchorPos = currentCheckPos;
                        break;
                    }
                    if (summonAnchorPos != null) break;
                }
                if (summonAnchorPos != null) break;
            }
            if (summonAnchorPos == null) {
                long currentTime = System.currentTimeMillis();
                UUID playerUuid = user.method_5667();
                if (!LAST_ERROR_MESSAGE_TIME.containsKey(playerUuid) || currentTime - LAST_ERROR_MESSAGE_TIME.get(playerUuid) > 30000L) {
                    user.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cSummon Anchor not found near the Altar"), false);
                    LAST_ERROR_MESSAGE_TIME.put(playerUuid, currentTime);
                }
                return class_9062.field_47733;
            }
            double spawnX = (double)summonAnchorPos.method_10263() + 0.5;
            double spawnY = summonAnchorPos.method_10264() + 1;
            double spawnZ = (double)summonAnchorPos.method_10260() + 0.5;
            String spawnCommand = randomNumber <= 50 ? "jirachi level=75 hp_iv=25 special_attack_iv=25 speed_iv=25 aspect=mythical" : (randomNumber <= 70 ? "jirachi level=75 hp_iv=31 special_attack_iv=31 speed_iv=31 aspect=mythical" : (randomNumber <= 90 ? "jirachi level=75 hp_iv=31 special_attack_iv=31 special_defence_iv=31 speed_iv=31 aspect=mythical" : (randomNumber <= 95 ? "jirachi level=75 hp_iv=31 attack_iv=31 defence_iv=31 special_attack_iv=31 special_defence_iv=31 speed_iv=31 nature=timid aspect=mythical" : (randomNumber <= 99 ? "jirachi shiny level=75" : "jirachi shiny level=90 hp_iv=31 attack_iv=31 defence_iv=31 special_attack_iv=31 special_defence_iv=31 speed_iv=31 nature=timid"))));
            class_3414 sound1 = class_3417.field_14627;
            class_3414 sound2 = class_3417.field_14709;
            class_3414 sound3 = class_3417.field_19167;
            class_3414 sound4 = (class_3414)class_3417.field_14793.comp_349();
            double finalSpawnX = spawnX;
            double finalSpawnY = spawnY;
            double finalSpawnZ = spawnZ;
            double particleRelOffsetY = 0.5;
            double particleRelOffsetZ = 0.0;
            stack.method_7934(1);
            if (!(user instanceof class_3222)) {
                return class_9062.field_47733;
            }
            class_3222 serverPlayer = (class_3222)user;
            serverPlayer.method_6092(new class_1293(class_1294.field_38092, 240, 3, false, false, false));
            serverPlayer.method_6092(new class_1293(class_1294.field_5909, 240, 10, false, false, false));
            class_243 playerNewPos = serverPlayer.method_19538();
            class_3218 finalServerWorld = (class_3218)world;
            finalServerWorld.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, ModSounds.LULLABY, class_3419.field_15247, 10.0f, 1.0f);
            Runnable otherSoundAndParticleTask = () -> {
                if (sound1 != null) {
                    finalServerWorld.method_43128(null, playerNewPos.field_1352, playerNewPos.field_1351, playerNewPos.field_1350, sound1, class_3419.field_15250, 10.0f, 0.8f);
                }
                if (sound2 != null) {
                    finalServerWorld.method_43128(null, playerNewPos.field_1352, playerNewPos.field_1351, playerNewPos.field_1350, sound2, class_3419.field_15250, 10.0f, 0.7f);
                }
                if (sound3 != null) {
                    finalServerWorld.method_43128(null, playerNewPos.field_1352, playerNewPos.field_1351, playerNewPos.field_1350, sound3, class_3419.field_15250, 20.0f, 1.0f);
                }
                if (sound4 != null) {
                    finalServerWorld.method_43128(null, playerNewPos.field_1352, playerNewPos.field_1351, playerNewPos.field_1350, sound4, class_3419.field_15250, 20.0f, 1.0f);
                }
                finalServerWorld.method_14199((class_2394)class_2398.field_11248, finalSpawnX, finalSpawnY + 0.5, finalSpawnZ + 0.0, 500, 1.0, 1.0, 1.0, 0.1);
                finalServerWorld.method_14199((class_2394)class_2398.field_11215, finalSpawnX, finalSpawnY + 0.5, finalSpawnZ + 0.0, 300, 0.5, 0.5, 0.5, 0.05);
                finalServerWorld.method_14199((class_2394)class_2398.field_38908, finalSpawnX, finalSpawnY + 0.5, finalSpawnZ + 0.0, 100, 0.2, 0.2, 0.2, 0.05);
                finalServerWorld.method_14199((class_2394)class_2398.field_28479, finalSpawnX, finalSpawnY + 0.5, finalSpawnZ + 0.0, 1, 0.0, 0.0, 0.0, 0.0);
                finalServerWorld.method_14199((class_2394)class_2398.field_29644, finalSpawnX, finalSpawnY + 0.5, finalSpawnZ + 0.0, 400, 1.5, 1.5, 1.5, 0.2);
            };
            SummonScheduler.scheduleTask(otherSoundAndParticleTask, 220);
            MinecraftServer server = serverPlayer.method_5682();
            if (server != null) {
                class_2168 spawnSource = serverPlayer.method_5671().method_9206(4);
                String finalSpawnCommand = String.format("pokespawnat %d %d %d %s", (int)Math.round(spawnX), (int)spawnY, (int)Math.round(spawnZ), spawnCommand);
                class_3222 finalServerPlayer = serverPlayer;
                MinecraftServer serverInstance = serverPlayer.method_5682();
                Runnable spawnTask = () -> {
                    if (serverInstance != null) {
                        try {
                            serverInstance.method_3734().method_9235().execute(serverInstance.method_3734().method_9235().parse(finalSpawnCommand, (Object)spawnSource));
                            finalServerPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aA Mythical Pok\u00e9mon has been summoned!"), false);
                        }
                        catch (CommandSyntaxException e) {
                            finalServerPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cError executing command: " + e.getMessage())), false);
                            LumyMon.LOGGER.error("Error executing pokespawn command: {}", (Object)spawnCommand, (Object)e);
                        }
                    }
                };
                SummonScheduler.scheduleTask(spawnTask, 220);
                int andesiteRadius = 6;
                class_2338 altarPos = pos;
                Runnable removeAndesiteTask = () -> {
                    for (int x = -6; x <= 6; ++x) {
                        for (int y = -6; y <= 6; ++y) {
                            for (int z = -6; z <= 6; ++z) {
                                class_2338 currentBlockPos = altarPos.method_10069(x, y, z);
                                class_2680 blockState = finalServerWorld.method_8320(currentBlockPos);
                                if (!blockState.method_27852(class_2246.field_10115)) continue;
                                finalServerWorld.method_8652(currentBlockPos, class_2246.field_10124.method_9564(), 3);
                                finalServerWorld.method_43128(null, (double)currentBlockPos.method_10263() + 0.5, (double)currentBlockPos.method_10264() + 0.5, (double)currentBlockPos.method_10260() + 0.5, class_3417.field_37339, class_3419.field_15245, 4.5f, 0.6f + finalServerWorld.field_9229.method_43057() * 0.05f);
                            }
                        }
                    }
                };
                SummonScheduler.scheduleTask(removeAndesiteTask, 210);
            }
            return class_9062.field_47729;
        }
        long currentTime = System.currentTimeMillis();
        UUID playerUuid = user.method_5667();
        if (!LAST_ERROR_MESSAGE_TIME.containsKey(playerUuid) || currentTime - LAST_ERROR_MESSAGE_TIME.get(playerUuid) > 30000L) {
            user.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cThis altar requires a Melodic Tape (Vol.1) to activate."), false);
            LAST_ERROR_MESSAGE_TIME.put(playerUuid, currentTime);
        }
        return class_9062.field_47733;
    }
}

