/*
 * Decompiled with CFR 0.152.
 */
package com.lumyverse.lumymon.util;

import com.lumyverse.lumymon.LumyMon;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public class SummonScheduler {
    private static final Queue<ScheduledTask> scheduledTasks = new ConcurrentLinkedQueue<ScheduledTask>();

    public static void scheduleTask(Runnable task, int delayTicks) {
        scheduledTasks.add(new ScheduledTask(task, delayTicks));
    }

    public static void register() {
        LumyMon.LOGGER.info("Registering SummonScheduler for lumymon");
        ServerTickEvents.END_SERVER_TICK.register(SummonScheduler::onServerTickEnd);
    }

    private static void onServerTickEnd(MinecraftServer server) {
        scheduledTasks.removeIf(scheduledTask -> {
            scheduledTask.decrementDelay();
            if (scheduledTask.getDelay() <= 0) {
                server.execute(scheduledTask.getTask());
                return true;
            }
            return false;
        });
    }

    private static class ScheduledTask {
        private final Runnable task;
        private int delay;

        public ScheduledTask(Runnable task, int delay) {
            this.task = task;
            this.delay = delay;
        }

        public Runnable getTask() {
            return this.task;
        }

        public int getDelay() {
            return this.delay;
        }

        public void decrementDelay() {
            --this.delay;
        }
    }
}

