/*
 * Decompiled with CFR 0.152.
 */
package com.example.chainmining;

import com.example.chainmining.config.ChainMiningConfig;
import com.example.chainmining.mining.MiningMode;
import com.example.chainmining.network.InventoryCollectPacket;
import com.example.chainmining.network.MiningModePacket;
import com.example.chainmining.network.NetworkHandler;
import com.example.chainmining.network.VeinMiningKeyPacket;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod(value="chainmining")
public class ChainMining {
    public static final String MODID = "chainmining";
    private static MiningMode currentMode = MiningMode.MODE_3X3;
    private static KeyMapping veinMineKey;
    private static KeyMapping modeSwitchKey;
    private static KeyMapping inventoryCollectKey;
    private static boolean wasVeinMineKeyDown;
    private static boolean wasInventoryCollectKeyDown;

    public ChainMining() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ChainMiningConfig.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkHandler.init();
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.Key event) {
        boolean isKeyDown;
        if (modeSwitchKey != null && modeSwitchKey.consumeClick()) {
            currentMode = currentMode.next();
            NetworkHandler.sendToServer(new MiningModePacket(currentMode));
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"message.chainmining.mode_switch", (Object[])new Object[]{currentMode.getDisplayName()}), true);
            }
        }
        if (veinMineKey != null && (isKeyDown = veinMineKey.isDown()) != wasVeinMineKeyDown) {
            wasVeinMineKeyDown = isKeyDown;
            NetworkHandler.sendToServer(new VeinMiningKeyPacket(isKeyDown));
        }
        if (inventoryCollectKey != null && inventoryCollectKey.consumeClick()) {
            boolean newState;
            wasInventoryCollectKeyDown = newState = !wasInventoryCollectKeyDown;
            NetworkHandler.sendToServer(new InventoryCollectPacket(newState));
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)("message.chainmining.inventory_collect_" + (newState ? "enabled" : "disabled"))), true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        boolean isVeinMiningActive;
        Player player = event.getPlayer();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        BlockPos pos = event.getPos();
        BlockState originalState = level.getBlockState(pos);
        Block targetBlock = originalState.getBlock();
        ItemStack tool = player.getMainHandItem();
        CompoundTag nbt = player.getPersistentData();
        boolean bl = isVeinMiningActive = nbt.contains("veinMiningKeyPressed") && nbt.getBoolean("veinMiningKeyPressed").orElse(false) != false;
        if (!isVeinMiningActive || player.isCrouching()) {
            return;
        }
        String saved = nbt.contains("currentMiningMode") ? nbt.getString("currentMiningMode").orElse("") : "";
        MiningMode mode = saved.isEmpty() ? MiningMode.MODE_3X3 : MiningMode.valueOf(saved);
        Set<BlockPos> toMine = switch (mode) {
            case MiningMode.MODE_3X3 -> this.getAreaBlocks(level, pos, targetBlock, player, tool);
            case MiningMode.MODE_STAIRCASE_DOWN, MiningMode.MODE_STAIRCASE_UP -> this.getStaircaseBlocks(level, pos, targetBlock, player, tool, mode);
            case MiningMode.MODE_CLUSTER -> this.isBlockSuitableForVeinMining(targetBlock) ? this.getClusterMineBlocks(level, pos, targetBlock, tool, player) : Collections.singleton(pos);
            default -> Collections.singleton(pos);
        };
        if (toMine.isEmpty()) {
            return;
        }
        this.limitBlocksByDurability(toMine, tool);
        this.mineBlocks(level, toMine, player, originalState);
    }

    private boolean isBlockSuitableForVeinMining(Block block) {
        if (block == Blocks.BEDROCK) {
            return false;
        }
        float hardness = block.defaultBlockState().getDestroySpeed(null, null);
        return (double)hardness >= (Double)ChainMiningConfig.MIN_BLOCK_HARDNESS.get() && (double)hardness <= (Double)ChainMiningConfig.MAX_BLOCK_HARDNESS.get();
    }

    private Set<BlockPos> getClusterMineBlocks(Level level, BlockPos startPos, Block targetBlock, ItemStack tool, Player player) {
        HashSet<BlockPos> toMine = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(startPos);
        while (!toCheck.isEmpty() && toMine.size() < (Integer)ChainMiningConfig.MAX_BLOCKS_PER_OPERATION.get()) {
            BlockState state;
            BlockPos pos = (BlockPos)toCheck.poll();
            if (toMine.contains(pos) || (state = level.getBlockState(pos)).getBlock() != targetBlock || !this.canPlayerBreakBlockWithTool(player, state, tool)) continue;
            toMine.add(pos);
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = pos.relative(dir);
                if (toMine.contains(neighbor)) continue;
                toCheck.add(neighbor);
            }
        }
        return toMine;
    }

    private Set<BlockPos> getAreaBlocks(Level level, BlockPos startPos, Block targetBlock, Player player, ItemStack tool) {
        HashSet<BlockPos> toMine = new HashSet<BlockPos>();
        int radius = 1;
        BlockState originalState = level.getBlockState(startPos);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = startPos.offset(x, y, z);
                    BlockState state = level.getBlockState(pos);
                    if (state.getBlock() != targetBlock || !this.canPlayerBreakBlockWithTool(player, state, tool)) continue;
                    toMine.add(pos);
                }
            }
        }
        return toMine;
    }

    private Set<BlockPos> getStaircaseBlocks(Level level, BlockPos startPos, Block targetBlock, Player player, ItemStack tool, MiningMode mode) {
        HashSet<BlockPos> toMine = new HashSet<BlockPos>();
        Direction facing = player.getDirection();
        boolean goingDown = mode == MiningMode.MODE_STAIRCASE_DOWN;
        int stairLength = 16;
        int height = 3;
        BlockState originalState = level.getBlockState(startPos);
        for (int step = 0; step < stairLength; ++step) {
            int yOffset = goingDown ? -step : step;
            BlockPos stepBase = startPos.offset(facing.getStepX() * step, yOffset, facing.getStepZ() * step);
            for (int h = 0; h < height; ++h) {
                BlockPos pos = stepBase.above(h);
                BlockState state = level.getBlockState(pos);
                if (state.getBlock() != targetBlock || !this.canPlayerBreakBlockWithTool(player, state, tool)) continue;
                toMine.add(pos);
            }
        }
        return toMine;
    }

    private void limitBlocksByDurability(Set<BlockPos> toMine, ItemStack tool) {
        if (tool.getMaxDamage() == 0) {
            return;
        }
        int remainingDurability = tool.getMaxDamage() - tool.getDamageValue();
        if (toMine.size() > remainingDurability) {
            List<Object> list = new ArrayList<BlockPos>(toMine);
            list = list.subList(0, remainingDurability);
            toMine.clear();
            toMine.addAll(list);
        }
    }

    private void mineBlocks(Level level, Set<BlockPos> toMine, Player player, BlockState originalState) {
        ItemStack tool = player.getMainHandItem();
        AtomicInteger mined = new AtomicInteger(0);
        CompoundTag playerNbt = player.getPersistentData();
        boolean collectToInventory = playerNbt.contains("inventoryCollectEnabled") && playerNbt.getBoolean("inventoryCollectEnabled").orElse(false) != false;
        for (BlockPos pos : toMine) {
            if (mined.get() >= (Integer)ChainMiningConfig.MAX_BLOCKS_PER_OPERATION.get()) break;
            BlockState stateToBreak = level.getBlockState(pos);
            if (level.isEmptyBlock(pos) || stateToBreak.getBlock() != originalState.getBlock() && !this.areBlocksSimilarForMining(stateToBreak.getBlock(), originalState.getBlock())) continue;
            List drops = Block.getDrops((BlockState)stateToBreak, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)tool);
            if (collectToInventory) {
                for (ItemStack drop : drops) {
                    if (player.getInventory().add(drop)) continue;
                    level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), drop));
                }
            } else {
                for (ItemStack drop : drops) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop));
                }
            }
            level.destroyBlock(pos, false, (Entity)player);
            if (tool.getMaxDamage() > 0) {
                tool.setDamageValue(tool.getDamageValue() + 1);
                if (tool.getDamageValue() >= tool.getMaxDamage()) break;
            }
            mined.incrementAndGet();
        }
    }

    private boolean canPlayerBreakBlockWithTool(Player player, BlockState state, ItemStack tool) {
        if (state.isAir() || state.getBlock() == Blocks.BEDROCK) {
            return false;
        }
        float hardness = state.getDestroySpeed(null, null);
        if ((double)hardness < (Double)ChainMiningConfig.MIN_BLOCK_HARDNESS.get() || (double)hardness > (Double)ChainMiningConfig.MAX_BLOCK_HARDNESS.get()) {
            return false;
        }
        if (state.requiresCorrectToolForDrops()) {
            return tool.isCorrectToolForDrops(state);
        }
        return true;
    }

    private boolean areBlocksSimilarForMining(Block block1, Block block2) {
        BlockState s1 = block1.defaultBlockState();
        BlockState s2 = block2.defaultBlockState();
        return Math.abs(s1.getDestroySpeed(null, null) - s2.getDestroySpeed(null, null)) < 1.0f && s1.requiresCorrectToolForDrops() == s2.requiresCorrectToolForDrops();
    }

    static {
        wasVeinMineKeyDown = false;
        wasInventoryCollectKeyDown = false;
    }

    @Mod.EventBusSubscriber(modid="chainmining", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEventHandler {
        @SubscribeEvent
        public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
            veinMineKey = new KeyMapping("key.chainmining.veinmine", InputConstants.Type.KEYSYM, 86, new KeyMapping.Category(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)ChainMining.MODID)));
            modeSwitchKey = new KeyMapping("key.chainmining.modeswitch", InputConstants.Type.KEYSYM, 77, new KeyMapping.Category(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)ChainMining.MODID)));
            inventoryCollectKey = new KeyMapping("key.chainmining.inventorycollect", InputConstants.Type.KEYSYM, 73, new KeyMapping.Category(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)ChainMining.MODID)));
            event.register(veinMineKey);
            event.register(modeSwitchKey);
            event.register(inventoryCollectKey);
        }
    }
}

