/*
 * Decompiled with CFR 0.152.
 */
package com.example.veinmine;

import com.example.veinmine.config.VeinMineConfig;
import com.example.veinmine.mining.MiningHandler;
import com.example.veinmine.mining.MiningMode;
import com.example.veinmine.network.VeinMineServerNetworking;
import com.example.veinmine.util.BlockUtils;
import com.example.veinmine.util.SmartMiningHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VeinMineMod
implements ModInitializer {
    public static final String MOD_ID = "veinmine";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"veinmine");
    public static VeinMineConfig CONFIG;
    private static final Map<UUID, Boolean> playerVeinMineActive;
    private static final Map<UUID, MiningMode> playerMiningModes;

    public void onInitialize() {
        LOGGER.info("Initializing Vein Mine Mod");
        CONFIG = VeinMineConfig.loadConfig();
        VeinMineServerNetworking.registerReceivers();
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                VeinMineMod.handleVeinMining(serverPlayer, world, pos, state);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> VeinMineMod.removePlayerData(handler.method_32311()));
    }

    public static void setVeinMineActive(class_3222 player, boolean active) {
        playerVeinMineActive.put(player.method_5667(), active);
    }

    public static boolean hasVeinMineActive(class_3222 player) {
        return playerVeinMineActive.getOrDefault(player.method_5667(), false);
    }

    public static void setPlayerMode(class_3222 player, MiningMode mode) {
        playerMiningModes.put(player.method_5667(), mode);
    }

    public static MiningMode getPlayerMode(class_3222 player) {
        return playerMiningModes.getOrDefault(player.method_5667(), MiningMode.VEIN);
    }

    public static void removePlayerData(class_3222 player) {
        playerVeinMineActive.remove(player.method_5667());
        playerMiningModes.remove(player.method_5667());
    }

    private static void handleVeinMining(class_3222 player, class_1937 world, class_2338 pos, class_2680 state) {
        if (!VeinMineMod.hasVeinMineActive(player)) {
            return;
        }
        MiningMode mode = VeinMineMod.getPlayerMode(player);
        boolean isSneaking = player.method_5715();
        if (CONFIG.isRequireSneaking() && !isSneaking) {
            return;
        }
        if (CONFIG.isDisableWhenSneaking() && isSneaking) {
            return;
        }
        class_2248 targetBlock = state.method_26204();
        String blockId = BlockUtils.getBlockId(state);
        if (CONFIG.getBlacklistedBlocks().contains(blockId)) {
            return;
        }
        class_1799 tool = player.method_6047();
        List<class_2338> blocksToBreak = MiningHandler.findBlocksToMine(world, pos, targetBlock, mode, player);
        for (class_2338 blockPos : blocksToBreak) {
            if (blocksToBreak.indexOf(blockPos) >= CONFIG.getMaxBlocks()) break;
            class_2680 targetState = world.method_8320(blockPos);
            class_2248 targetBlockType = targetState.method_26204();
            if (SmartMiningHelper.isDangerousBlock(targetBlockType) || !VeinMineMod.canToolMineBlock(tool, targetState, world, blockPos, player)) continue;
            world.method_8651(blockPos, true, (class_1297)player);
        }
    }

    private static boolean canToolMineBlock(class_1799 tool, class_2680 blockState, class_1937 world, class_2338 pos, class_3222 player) {
        if (!tool.method_7951(blockState)) {
            return false;
        }
        float hardness = blockState.method_26214((class_1922)world, pos);
        if (hardness < 0.0f) {
            return false;
        }
        float breakingSpeed = tool.method_7924(blockState);
        return !(breakingSpeed <= 1.0f);
    }

    static {
        playerVeinMineActive = new HashMap<UUID, Boolean>();
        playerMiningModes = new HashMap<UUID, MiningMode>();
    }
}

